/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NullIf;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract;
import org.apache.spark.sql.catalyst.expressions.RegExpSubStr$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Returns the substring that matches the regular expression `regexp` within the string `str`. If the regular expression is not found, the result is null.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a Java regular expression.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Ste(v|ph)en');\n       Steven\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Jeck');\n       NULL\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u000f\u001e\u0001*B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005W!A!\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005L\u0001\tE\t\u0015!\u0003,\u0011\u0015a\u0005\u0001\"\u0001N\u0011!\t\u0006\u0001#b\u0001\n\u0003B\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00026\u0001\t#Z\u0007bB9\u0001\u0003\u0003%\tA\u001d\u0005\bk\u0002\t\n\u0011\"\u0001w\u0011!\t\u0019\u0001AI\u0001\n\u00031\b\"CA\u0003\u0001\u0005\u0005I\u0011IA\u0004\u0011%\t9\u0002AA\u0001\n\u0003\tI\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\t\u0013\u0005E\u0003!!A\u0005B\u0005Ms!CA?;\u0005\u0005\t\u0012AA@\r!aR$!A\t\u0002\u0005\u0005\u0005B\u0002'\u0017\t\u0003\tI\nC\u0005\u0002\u001cZ\t\t\u0011\"\u0012\u0002\u001e\"I\u0011q\u0014\f\u0002\u0002\u0013\u0005\u0015\u0011\u0015\u0005\n\u0003O3\u0012\u0011!CA\u0003SC\u0011\"a/\u0017\u0003\u0003%I!!0\u0003\u0019I+w-\u0012=q'V\u00147\u000b\u001e:\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00160eUZ\u0004C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003YAJ!!M\u000f\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003YMJ!\u0001N\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002=\t:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001&\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\r;\u0014a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aQ\u001c\u0002\t1,g\r^\u000b\u0002W\u0005)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001(P!B\u0011A\u0006\u0001\u0005\u0006\u000f\u0016\u0001\ra\u000b\u0005\u0006\u0015\u0016\u0001\raK\u0001\fe\u0016\u0004H.Y2f[\u0016tG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u0016\t\u0003+fs!AV,\u0011\u0005y:\u0014B\u0001-8\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a;\u0014\u0001C2iS2$'/\u001a8\u0016\u0003y\u00032\u0001P0,\u0013\t\u0001gIA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\u0007c\u0001\u001f`IB\u0011Q\r[\u0007\u0002M*\u0011q-I\u0001\u0006if\u0004Xm]\u0005\u0003S\u001a\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGC\u0001(m\u0011\u0015i'\u00021\u0001o\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007qz7&\u0003\u0002q\r\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0004\u001dN$\bbB$\f!\u0003\u0005\ra\u000b\u0005\b\u0015.\u0001\n\u00111\u0001,\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001e\u0016\u0003Wa\\\u0013!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005y<\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003'\tAA[1wC&\u0019!,!\u0004\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0001c\u0001\u001c\u0002\u001e%\u0019\u0011qD\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00121\u0006\t\u0004m\u0005\u001d\u0012bAA\u0015o\t\u0019\u0011I\\=\t\u0013\u00055\u0002#!AA\u0002\u0005m\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00024A1\u0011QGA\u001e\u0003Ki!!a\u000e\u000b\u0007\u0005er'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0010\u00028\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019%!\u0013\u0011\u0007Y\n)%C\u0002\u0002H]\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002.I\t\t\u00111\u0001\u0002&\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI!a\u0014\t\u0013\u000552#!AA\u0002\u0005m\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002D\u0005U\u0003\"CA\u0017)\u0005\u0005\t\u0019AA\u0013Q]\u0001\u0011\u0011LA0\u0003C\n)'a\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI\bE\u0002-\u00037J1!!\u0018\u001e\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0019\u0002\u0003WR\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\b/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tk\n\u001cHO]5oO\u0002\"\b.\u0019;![\u0006$8\r[3tAQDW\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004\u0003M]3hKb\u0004\b\rI<ji\"Lg\u000e\t;iK\u0002\u001aHO]5oO\u0002\u00027\u000f\u001e:a]\u0001Je\r\t;iK\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!SN\u0004cn\u001c;!M>,h\u000e\u001a\u0017!i\",\u0007E]3tk2$\b%[:!]VdGN\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003S\n\u0011\u0011\u000b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,w-\u001a=qA5\u0002\u0013\rI:ue&tw\r\t:faJ,7/\u001a8uS:<\u0007%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u0012XmZ3yAM$(/\u001b8hAMDw.\u001e7eA\t,\u0007%\u0019\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qN\u0001\u0002>*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u0015;fm\u0016t\u0007ES8oKN\u0004\u0013M\u001c3!'R,\u0007\u000f[3oAMk\u0017\u000e\u001e5!CJ,\u0007\u0005\u001e5fA\t,7\u000f\u001e\u0011qY\u0006LXM]:(Y\u0001:3\u000b^3)mr\u0004\b.K3oO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0015;fm\u0016t'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ti\u00164XM\u001c\u0011K_:,7\u000fI1oI\u0002\u001aF/\u001a9iK:\u00043+\\5uQ\u0002\n'/\u001a\u0011uQ\u0016\u0004#-Z:uAAd\u0017-_3sg\u001eb\u0003e\n&fG.<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0014!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAA>\u00031\u0019HO]5oO~3WO\\2t\u00031\u0011VmZ#yaN+(m\u0015;s!\taccE\u0003\u0017\u0003\u0007\u000by\tE\u0004\u0002\u0006\u0006-5f\u000b(\u000e\u0005\u0005\u001d%bAAEo\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003#\t!![8\n\u0007\u0015\u000b\u0019\n\u0006\u0002\u0002\u0000\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\n\u0005)\u0011\r\u001d9msR)a*a)\u0002&\")q)\u0007a\u0001W!)!*\u0007a\u0001W\u00059QO\\1qa2LH\u0003BAV\u0003o\u0003RANAW\u0003cK1!a,8\u0005\u0019y\u0005\u000f^5p]B)a'a-,W%\u0019\u0011QW\u001c\u0003\rQ+\b\u000f\\33\u0011!\tILGA\u0001\u0002\u0004q\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0018\t\u0005\u0003\u0017\t\t-\u0003\u0003\u0002D\u00065!AB(cU\u0016\u001cG\u000f")
public class RegExpSubStr
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegExpSubStr x$0) {
        return RegExpSubStr$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, RegExpSubStr> tupled() {
        return RegExpSubStr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegExpSubStr>> curried() {
        return RegExpSubStr$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        RegExpSubStr regExpSubStr = this;
        synchronized (regExpSubStr) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        RegExpSubStr regExpSubStr = this;
        synchronized (regExpSubStr) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new NullIf(new RegExpExtract(this.left(), this.right(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0))), Literal$.MODULE$.create("", this.left().dataType()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "regexp_substr";
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public RegExpSubStr withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public RegExpSubStr copy(Expression left, Expression right) {
        return new RegExpSubStr(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegExpSubStr";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpSubStr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpSubStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpSubStr regExpSubStr = (RegExpSubStr)x$1;
        Expression expression = this.left();
        Expression expression2 = regExpSubStr.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regExpSubStr.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regExpSubStr.canEqual(this)) return false;
        return true;
    }

    public RegExpSubStr(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

