/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorDecommission;
import org.apache.spark.scheduler.ExecutorDecommission$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dg!B\u001b7\u0001q\u0012\u0005\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011i\u0004!\u0011!Q\u0001\nmDQA \u0001\u0005\u0002}D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005M\u0002\u0001)A\u0005\u00033A\u0011\"!\u000e\u0001\u0005\u0004%\t&a\u000e\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003sA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005u\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005=\u0004\u0001)A\u0005\u0003GB\u0011\"!\u001d\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005M\u0004\u0001)A\u0005\u00033A\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003sB\u0001\"!\"\u0001\t\u00031\u0014q\u0011\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\tY\f\u0001C!\u0003{Cq!a0\u0001\t\u0003\n\t\rC\u0004\u0002D\u0002!\t%!1\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqA!\u0002\u0001\t\u0003\u00129\u0001C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t=\u0002\u0001\"\u0011\u00032!I!1\b\u0001C\u0002\u0013\u0005!Q\b\u0005\t\u0005\u0017\u0002\u0001\u0015!\u0003\u0003@!9!Q\n\u0001\u0005R\t=\u0003b\u0002B2\u0001\u0011E#Q\r\u0004\u0007\u0005[\u0002AAa\u001c\t\rydC\u0011\u0001B9\u0011%\u0011)\b\fb\u0001\n#\u00119\b\u0003\u0005\u0003\u00162\u0002\u000b\u0011\u0002B=\u0011\u001d\u00119\n\fC\u0005\u00053CqA!--\t\u0013\u0011\u0019\fC\u0004\u000362\"\tEa.\t\u000f\tmF\u0006\"\u0011\u0003>\"q!1\u0019\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002B\n\u0015'!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u001c9\u0003\rY\u0007h\u001d\u0006\u0003si\nqa\u00197vgR,'O\u0003\u0002<y\u0005I1o\u00195fIVdWM\u001d\u0006\u0003{y\nQa\u001d9be.T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sON\u0011\u0001a\u0011\t\u0003\t\u0016k\u0011\u0001O\u0005\u0003\rb\u0012QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0002\u0001!\tI%*D\u0001;\u0013\tY%HA\tUCN\\7k\u00195fIVdWM]%na2\f!a]2\u0011\u00059{U\"\u0001\u001f\n\u0005Ac$\u0001D*qCJ\\7i\u001c8uKb$\u0018\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t\u0019F,D\u0001U\u0015\t)f+\u0001\u0004dY&,g\u000e\u001e\u0006\u0003/b\u000b!b[;cKJtW\r^3t\u0015\tI&,A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003m\u000b!![8\n\u0005u#&\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007C\u00011h\u001b\u0005\t'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u0016\fA!\u001e;jY*\ta-\u0001\u0003kCZ\f\u0017B\u00015b\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tYG.D\u00017\u0013\tigG\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-\u0001\u0007q_\u0012\fE\u000e\\8dCR|'\u000f\u0005\u0002la&\u0011\u0011O\u000e\u0002\u0016\u0003\n\u001cHO]1diB{Gm]!mY>\u001c\u0017\r^8s\u0003Ua\u0017NZ3ds\u000edW-\u0012<f]RD\u0015M\u001c3mKJ\u0004\"a\u001b;\n\u0005U4$\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\fo\u0006$8\r[#wK:$8\u000f\u0005\u0002lq&\u0011\u0011P\u000e\u0002 \u000bb,7-\u001e;peB{Gm],bi\u000eD7K\\1qg\"|GoU8ve\u000e,\u0017A\u00039pY2,e/\u001a8ugB\u00111\u000e`\u0005\u0003{Z\u0012\u0011%\u0012=fGV$xN\u001d)pIN\u0004v\u000e\u001c7j]\u001e\u001cf.\u00199tQ>$8k\\;sG\u0016\fa\u0001P5oSRtD\u0003FA\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002l\u0001!)1H\u0003a\u0001\u0011\")AJ\u0003a\u0001\u001b\")\u0011K\u0003a\u0001%\")aL\u0003a\u0001?\")\u0011N\u0003a\u0001U\")aN\u0003a\u0001_\")!O\u0003a\u0001g\")aO\u0003a\u0001o\")!P\u0003a\u0001w\u0006)\u0011\r\u001d9JIV\u0011\u0011\u0011\u0004\t\u0005\u00037\tiC\u0004\u0003\u0002\u001e\u0005%\u0002\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rr)\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003O\tQa]2bY\u0006LA!a\u000b\u0002&\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eTA!a\u000b\u0002&\u00051\u0011\r\u001d9JI\u0002\n!#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_V\u0011\u0011\u0011\b\t\u0005\u0003w\ti$\u0004\u0002\u0002&%!\u0011qHA\u0013\u0005\u0019!u.\u001e2mK\u0006\u0019R.\u001b8SK\u001eL7\u000f^3sK\u0012\u0014\u0016\r^5pA\u0005\u0001\u0012N\\5uS\u0006dW\t_3dkR|'o]\u000b\u0003\u0003\u000f\u0002B!a\u000f\u0002J%!\u00111JA\u0013\u0005\rIe\u000e^\u0001\u0012S:LG/[1m\u000bb,7-\u001e;peN\u0004\u0013!G:i_VdG\rR3mKR,GI]5wKJ\u001cVM\u001d<jG\u0016,\"!a\u0015\u0011\t\u0005m\u0012QK\u0005\u0005\u0003/\n)CA\u0004C_>dW-\u00198\u00025MDw.\u001e7e\t\u0016dW\r^3Ee&4XM]*feZL7-\u001a\u0011\u0002+MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u000612\u000f[8vY\u0012$U\r\\3uK\u0016CXmY;u_J\u001c\b%\u0001\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%D(\u0001\u0005sKN|WO]2f\u0013\u0011\ti'a\u001a\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\fq\u0002Z3gCVdG\u000f\u0015:pM&dW\rI\u0001\n]\u0006lWm\u001d9bG\u0016\f!B\\1nKN\u0004\u0018mY3!\u0003e\u0001x\u000e\u001a#fY\u0016$\u0018n\u001c8D_N$\u0018I\u001c8pi\u0006$\u0018n\u001c8\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}T-\u0001\u0003mC:<\u0017\u0002BA\u0018\u0003{\n!\u0004]8e\t\u0016dW\r^5p]\u000e{7\u000f^!o]>$\u0018\r^5p]\u0002\n\u0001\u0003Z8SK6|g/Z#yK\u000e,Ho\u001c:\u0015\r\u0005%\u0015qRAJ!\u0011\tY$a#\n\t\u00055\u0015Q\u0005\u0002\u0005+:LG\u000fC\u0004\u0002\u0012n\u0001\r!!\u0007\u0002\u0015\u0015DXmY;u_JLE\rC\u0004\u0002\u0016n\u0001\r!a&\u0002\rI,\u0017m]8o!\rI\u0015\u0011T\u0005\u0004\u00037S$AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:\fac]3u+B,\u00050Z2vi>\u00148i\u001c8gS\u001el\u0015\r\u001d\u000b\u0005\u0003\u0013\u000b\t\u000bC\u0004\u0002$r\u0001\r!!*\u0002\u0013\u0011\u0014\u0018N^3s!>$\u0007CBA\u001e\u0003O\u000bY+\u0003\u0003\u0002*\u0006\u0015\"AB(qi&|g\u000e\u0005\u0003\u0002.\u0006]VBAAX\u0015\u0011\t\t,a-\u0002\u000b5|G-\u001a7\u000b\u0007\u0005Uf+A\u0002ba&LA!!/\u00020\n\u0019\u0001k\u001c3\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\t\tI\"A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\n\u0006!1\u000f^8q\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002J\u0006M\u0007CBAf\u0003\u001f\f\u0019&\u0004\u0002\u0002N*\u0019!-!\n\n\t\u0005E\u0017Q\u001a\u0002\u0007\rV$XO]3\t\u000f\u0005U\u0007\u00051\u0001\u0002X\u0006Y\"/Z:pkJ\u001cW\r\u0015:pM&dW\rV8U_R\fG.\u0012=fGN\u0004\u0002\"a\u0007\u0002Z\u0006\r\u0014qI\u0005\u0005\u00037\f\tDA\u0002NCB\fQd];gM&\u001c\u0017.\u001a8u%\u0016\u001cx.\u001e:dKN\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0003\u0003'\nabZ3u\u000bb,7-\u001e;pe&#7\u000f\u0006\u0002\u0002fB1\u0011q]Ay\u00033qA!!;\u0002n:!\u0011qDAv\u0013\t\t9#\u0003\u0003\u0002p\u0006\u0015\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003g\f)PA\u0002TKFTA!a<\u0002&\u0005a\u0012M\u001c8pi\u0006$X-\u0012=fGV$xN\u001d#fY\u0016$\u0018n\u001c8D_N$H\u0003BAE\u0003wDq!!@$\u0001\u0004\t)/A\u0004fq\u0016\u001c\u0017\nZ:\u000231\f'-\u001a7EK\u000e|W.\\5tg&|g.\u001b8h\u000bb,7m\u001d\u000b\u0005\u0003\u0013\u0013\u0019\u0001C\u0004\u0002~\u0012\u0002\r!!:\u0002+\u0011,7m\\7nSN\u001c\u0018n\u001c8Fq\u0016\u001cW\u000f^8sgRA\u0011Q\u001dB\u0005\u0005?\u0011\u0019\u0003C\u0004\u0003\f\u0015\u0002\rA!\u0004\u0002+\u0015DXmY;u_J\u001c\u0018I\u001c3EK\u000e|W.\u00138g_B1\u00111\bB\b\u0005'IAA!\u0005\u0002&\t)\u0011I\u001d:bsBA\u00111\bB\u000b\u00033\u0011I\"\u0003\u0003\u0003\u0018\u0005\u0015\"A\u0002+va2,'\u0007E\u0002J\u00057I1A!\b;\u0005a)\u00050Z2vi>\u0014H)Z2p[6L7o]5p]&sgm\u001c\u0005\b\u0005C)\u0003\u0019AA*\u0003a\tGM[;tiR\u000b'oZ3u\u001dVlW\t_3dkR|'o\u001d\u0005\b\u0005K)\u0003\u0019AA*\u0003M!(/[4hKJ,GMQ=Fq\u0016\u001cW\u000f^8s\u0003=!wnS5mY\u0016CXmY;u_J\u001cH\u0003BAe\u0005WAqA!\f'\u0001\u0004\t)/A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\u0018\u0001F2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0002\u00034A!!Q\u0007B\u001c\u001b\u0005\u0001\u0011b\u0001B\u001d\u000b\nqAI]5wKJ,e\u000e\u001a9pS:$\u0018AB3yK\u000eLE-\u0006\u0002\u0003@A!!\u0011\tB$\u001b\t\u0011\u0019EC\u0002\u0003F\u0005\fa!\u0019;p[&\u001c\u0017\u0002\u0002B%\u0005\u0007\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018aB3yK\u000eLE\rI\u0001\u0013GJ,\u0017\r^3U_.,g.T1oC\u001e,'\u000f\u0006\u0002\u0003RA1\u00111HAT\u0005'\u0002BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\u0011i\u0006P\u0001\u0007I\u0016\u0004Hn\\=\n\t\t\u0005$q\u000b\u0002\u001d\u0011\u0006$wn\u001c9EK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0003II7/\u0012=fGV$xN]#yG2,H-\u001a3\u0015\r\u0005M#q\rB5\u0011\u001d\t\tj\u000ba\u0001\u00033AqAa\u001b,\u0001\u0004\tI\"\u0001\u0005i_N$h.Y7f\u0005aYUOY3s]\u0016$Xm\u001d#sSZ,'/\u00128ea>Lg\u000e^\n\u0004Y\tMBC\u0001B:!\r\u0011)\u0004L\u0001\u0010Kb,7-\u0013#SKF,Xm\u001d;feV\u0011!\u0011\u0010\t\t\u0005w\u0012)I!#\u0002\u001a5\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0004nkR\f'\r\\3\u000b\t\t\r\u0015QE\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BD\u0005{\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y\tP\u0001\u0004eB\u001c\u0017\u0002\u0002BJ\u0005\u001b\u0013!B\u00159d\u0003\u0012$'/Z:t\u0003A)\u00070Z2J\tJ+\u0017/^3ti\u0016\u0014\b%\u0001\bhK:,'/\u0019;f\u000bb,7-\u0013#\u0015\t\tm%q\u0015\t\t\u0003w\u0011iJ!)\u0002\n&!!qTA\u0013\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0003BA\u001e\u0005GKAA!*\u0002&\t\u0019\u0011I\\=\t\u000f\t%\u0006\u00071\u0001\u0003,\u000691m\u001c8uKb$\b\u0003\u0002BF\u0005[KAAa,\u0003\u000e\nq!\u000b]2DC2d7i\u001c8uKb$\u0018AJ5h]>\u0014XMU3hSN$XM]#yK\u000e,Ho\u001c:BiN#x\u000e\u001d9fI\u000e{g\u000e^3yiV\u0011!1T\u0001\u0010e\u0016\u001cW-\u001b<f\u0003:$'+\u001a9msR!!1\u0014B]\u0011\u001d\u0011IK\ra\u0001\u0005W\u000bab\u001c8ESN\u001cwN\u001c8fGR,G\r\u0006\u0003\u0002\n\n}\u0006b\u0002Bag\u0001\u0007!\u0011R\u0001\u000beB\u001c\u0017\t\u001a3sKN\u001c\u0018AC:va\u0016\u0014He\u001d;pa&\u0019\u00111Y#")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    public final ScheduledExecutorService org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final AbstractPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final String appId;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteDriverService;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation;
    private final AtomicInteger execId;

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    private String appId() {
        return this.appId;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteDriverService() {
        return this.shouldDeleteDriverService;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map resolvedExecutorProperties = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())}));
        Map confFilesMap = (Map)KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)resolvedExecutorProperties).$plus$plus((IterableOnce)resolvedExecutorProperties);
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (Map<String, String>)confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<HasMetadata>)new .colon.colon((Object)configMap, (List)Nil$.MODULE$));
        ((CreateOrReplaceable)((AnyNamespaceOperation)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).resource((Object)configMap)).create();
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").getOrElse((Function0 & Serializable)() -> this.appId());
    }

    public void start() {
        super.start();
        this.podAllocator.start(this.applicationId(), this);
        Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
        this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
        this.lifecycleEventHandler.start(this);
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
            this.setUpExecutorConfigMap(this.podAllocator.driverPod());
            return;
        }
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteDriverService()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.services().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC()))) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.persistentVolumeClaims().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (this.shouldDeleteExecutors()) {
            this.podAllocator.stop(this.applicationId());
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            }
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    private void annotateExecutorDeletionCost(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_DELETION_COST())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)cost -> {
            this.logInfo((Function0 & Serializable)() -> "Annotating executor pod(s) " + execIds.mkString(",") + " with deletion cost " + cost);
            Runnable annotateTask = new Runnable(this, execIds, cost){
                private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
                private final Seq execIds$1;
                private final int cost$1;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$1.toArray(ClassTag$.MODULE$.apply(String.class)))).resources().forEach(podResource -> podResource.edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editOrNewMetadata().addToAnnotations($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation(), Integer.toString($this.cost$1))).endMetadata()).build())));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execIds$1 = execIds$1;
                    this.cost$1 = cost$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 )}, serializedLambda);
                }
            };
            $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(annotateTask);
        });
    }

    private void labelDecommissioningExecs(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL())).foreach((Function1 & Serializable)label -> {
            KubernetesClusterSchedulerBackend.$anonfun$labelDecommissioningExecs$1(this, execIds, label);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> decommissionExecutors(Tuple2<String, ExecutorDecommissionInfo>[] executorsAndDecomInfo, boolean adjustTargetNumExecutors, boolean triggeredByExecutor) {
        block1: {
            if (triggeredByExecutor) break block1;
            this.labelDecommissioningExecs((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo), (Function1 & Serializable)x$1 -> (String)x$1._1(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
            if (((String)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR())).equals("deployment")) {
                this.annotateExecutorDeletionCost((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo), (Function1 & Serializable)x$2 -> (String)x$2._1(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
            }
        }
        return super.decommissionExecutors(executorsAndDecomInfo, adjustTargetNumExecutors, triggeredByExecutor);
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        if (((String)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR())).equals("deployment")) {
            this.annotateExecutorDeletionCost(executorIds);
        }
        this.labelDecommissioningExecs(executorIds);
        executorIds.foreach((Function1 & Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                    if (!((PodList)running.list()).getItems().isEmpty()) {
                        $this.$outer.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Forcefully deleting ", " pods "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)((PodList)running.list()).getItems().size()))})).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(out of ", ") that are still running after graceful "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.TOTAL, BoxesRunTime.boxToInteger((int)$this.executorIds$1.size()))}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"shutdown period."}))).log((Seq)Nil$.MODULE$))));
                        running.delete();
                        return;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$8(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$3 ), $anonfun$run$9(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$3 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public AtomicInteger execId() {
        return this.execId;
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public static final /* synthetic */ void $anonfun$labelDecommissioningExecs$1(KubernetesClusterSchedulerBackend $this, Seq execIds$2, String label) {
        Runnable labelTask = new Runnable($this, execIds$2, label){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq execIds$2;
            private final String label$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$2.toArray(ClassTag$.MODULE$.apply(String.class)))).resources().forEach(podResource -> podResource.edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editOrNewMetadata().addToLabels($this.label$1, (String)((Option)$this.$outer.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE())).getOrElse((Function0 & Serializable)() -> ""))).endMetadata()).build())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.execIds$2 = execIds$2;
                this.label$1 = label$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 ), $anonfun$run$7()}, serializedLambda);
            }
        };
        $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, AbstractPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.appId = KubernetesConf$.MODULE$.getKubernetesAppId();
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteDriverService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_DELETE_ON_TERMINATION()));
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace = (String)this.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation = "controller.kubernetes.io/pod-deletion-cost";
        this.execId = new AtomicInteger(0);
    }

    private class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private final HashMap<RpcAddress, String> execIDRequester = new HashMap();

        public HashMap<RpcAddress, String> execIDRequester() {
            return this.execIDRequester;
        }

        private PartialFunction<Object, BoxedUnit> generateExecID(RpcCallContext context) {
            return new Serializable(this, context){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof GenerateExecID) {
                        GenerateExecID generateExecID2 = (GenerateExecID)A1;
                        String newId = Integer.toString(this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().execId().incrementAndGet());
                        this.context$1.reply((Object)newId);
                        RpcAddress executorAddress = this.context$1.senderAddress();
                        this.$outer.execIDRequester().update((Object)executorAddress, (Object)newId);
                        Runnable labelTask = new Runnable(this, generateExecID2, newId){
                            private final /* synthetic */ KubernetesDriverEndpoint$$anonfun$generateExecID$1 $outer;
                            private final GenerateExecID x2$1;
                            private final String newId$1;

                            public void run() {
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((EditReplacePatchable)((Nameable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withName($this.x2$1.podName())).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), $this.newId$1)).endMetadata()).build()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x2$1 = x2$1;
                                this.newId$1 = newId$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$10(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$generateExecID$1$$anon$4 )}, serializedLambda);
                            }
                        };
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof GenerateExecID;
                }

                public /* synthetic */ KubernetesDriverEndpoint org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.generateExecID(context).orElse(this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context)));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            Option execId = this.addressToExecutorId().get((Object)rpcAddress);
            Option option = execId;
            if (option instanceof Some) {
                Some some = (Some)option;
                String id = (String)some.value();
                Option option2 = this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().executorsPendingDecommission().get((Object)id);
                if (option2 instanceof Some) {
                    this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().removeExecutor(id, (ExecutorLossReason)new ExecutorDecommission((Option)None$.MODULE$, ExecutorDecommission$.MODULE$.apply$default$2()));
                } else {
                    this.disableExecutor(id);
                }
                return;
            }
            Option newExecId = this.execIDRequester().get((Object)rpcAddress);
            Option option3 = newExecId;
            if (option3 instanceof Some) {
                this.execIDRequester().$minus$eq((Object)rpcAddress);
            } else {
                this.logDebug((Function0 & Serializable)() -> "No executor found for " + rpcAddress);
            }
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

