/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.internal;

import java.util.Map;
import org.sparkproject.connect.grpc.NameResolver;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.connect.grpc.internal.AutoConfiguredLoadBalancerFactory;
import org.sparkproject.connect.grpc.internal.ManagedChannelServiceConfig;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;

@VisibleForTesting
public final class ScParser
extends NameResolver.ServiceConfigParser {
    private final boolean retryEnabled;
    private final int maxRetryAttemptsLimit;
    private final int maxHedgedAttemptsLimit;
    private final AutoConfiguredLoadBalancerFactory autoLoadBalancerFactory;

    public ScParser(boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit, AutoConfiguredLoadBalancerFactory autoLoadBalancerFactory) {
        this.retryEnabled = retryEnabled;
        this.maxRetryAttemptsLimit = maxRetryAttemptsLimit;
        this.maxHedgedAttemptsLimit = maxHedgedAttemptsLimit;
        this.autoLoadBalancerFactory = (AutoConfiguredLoadBalancerFactory)Preconditions.checkNotNull((Object)autoLoadBalancerFactory, (Object)"autoLoadBalancerFactory");
    }

    @Override
    public NameResolver.ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
        try {
            Object loadBalancingPolicySelection;
            NameResolver.ConfigOrError choiceFromLoadBalancer = this.autoLoadBalancerFactory.parseLoadBalancerPolicy(rawServiceConfig);
            if (choiceFromLoadBalancer == null) {
                loadBalancingPolicySelection = null;
            } else {
                if (choiceFromLoadBalancer.getError() != null) {
                    return NameResolver.ConfigOrError.fromError(choiceFromLoadBalancer.getError());
                }
                loadBalancingPolicySelection = choiceFromLoadBalancer.getConfig();
            }
            return NameResolver.ConfigOrError.fromConfig(ManagedChannelServiceConfig.fromServiceConfig(rawServiceConfig, this.retryEnabled, this.maxRetryAttemptsLimit, this.maxHedgedAttemptsLimit, loadBalancingPolicySelection));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNKNOWN.withDescription("failed to parse service config").withCause(e));
        }
    }
}

