/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.deploy.LocalSparkCluster$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.JavaModuleOptions;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static final SparkContext$ MODULE$ = new SparkContext$();
    private static final Set<String> VALID_LOG_LEVELS;
    private static final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private static final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private static Option<SparkContext> contextBeingConstructed;
    private static final String SPARK_JOB_DESCRIPTION;
    private static final String SPARK_JOB_GROUP_ID;
    private static final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private static final String SPARK_JOB_TAGS;
    private static final String SPARK_SCHEDULER_POOL;
    private static final String RDD_SCOPE_KEY;
    private static final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private static final String DRIVER_IDENTIFIER;
    private static final String SPARK_JOB_TAGS_SEP;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        contextBeingConstructed = None$.MODULE$;
        SPARK_JOB_DESCRIPTION = "spark.job.description";
        SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        SPARK_JOB_TAGS = "spark.job.tags";
        SPARK_SCHEDULER_POOL = "spark.scheduler.pool";
        RDD_SCOPE_KEY = "spark.rdd.scope";
        RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        DRIVER_IDENTIFIER = "driver";
        SPARK_JOB_TAGS_SEP = ",";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> VALID_LOG_LEVELS() {
        return VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1 & Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$1(sc, x$65))).foreach((Function1 & Serializable)ctx -> {
                String errMsg = "Only one SparkContext should be running in this JVM (see SPARK-2243).The currently running SparkContext was created at:\n" + ctx.org$apache$spark$SparkContext$$creationSite().longForm();
                throw new SparkException(errMsg);
            });
            this.contextBeingConstructed().filter((Function1 & Serializable)x$66 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$3(sc, x$66))).foreach((Function1 & Serializable)otherContext -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$4(otherContext);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void org$apache$spark$SparkContext$$assertOnDriver() {
        if (Utils$.MODULE$.isInRunningSparkTask()) {
            throw new IllegalStateException("SparkContext should only be created and accessed on the driver.");
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config));
            } else if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])config.getAll()))) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Using an existing SparkContext; some configuration may not take effect.");
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public SparkContext getOrCreate() {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext());
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public Option<SparkContext> getActive() {
        Option option;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get());
        }
        return option;
    }

    public void markPartiallyConstructed(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
        }
    }

    public void setActiveContext(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String SPARK_JOB_TAGS() {
        return SPARK_JOB_TAGS;
    }

    public String SPARK_SCHEDULER_POOL() {
        return SPARK_SCHEDULER_POOL;
    }

    public String RDD_SCOPE_KEY() {
        return RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return DRIVER_IDENTIFIER;
    }

    public String SPARK_JOB_TAGS_SEP() {
        return SPARK_JOB_TAGS_SEP;
    }

    public void throwIfInvalidTag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Spark job tag cannot be null.");
        }
        if (tag.contains(this.SPARK_JOB_TAGS_SEP())) {
            throw new IllegalArgumentException("Spark job tag cannot contain '" + this.SPARK_JOB_TAGS_SEP() + "'.");
        }
        if (tag.isEmpty()) {
            throw new IllegalArgumentException("Spark job tag cannot be an empty string.");
        }
    }

    public Option<String> jarOfClass(Class<?> cls) {
        URL uri = cls.getResource("/" + cls.getName().replace('.', '/') + ".class");
        if (uri != null) {
            String uriStr = uri.toString();
            if (uriStr.startsWith("jar:file:")) {
                return new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33)));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome != null ? res.setSparkHome(sparkHome) : BoxedUnit.UNIT;
        Object object2 = jars != null && !jars.isEmpty() ? res.setJars(jars) : BoxedUnit.UNIT;
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        return this.numDriverCores(master, null);
    }

    public int numDriverCores(String master, SparkConf conf) {
        Option option;
        Option option2;
        Option option3;
        String string = master;
        if ("local".equals(string)) {
            return 1;
        }
        if (string != null && !(option3 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(1) == 0) {
            String threads = (String)((LinearSeqOps)option3.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if (string != null && !(option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOps)option2.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if ("yarn".equals(string) ? true : string != null && !(option = SparkMasterRegex$.MODULE$.KUBERNETES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            if (conf != null) {
                String string2 = conf.get(package$.MODULE$.SUBMIT_DEPLOY_MODE());
                String string3 = "cluster";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return conf.getInt(package$.MODULE$.DRIVER_CORES().key(), 0);
                }
            }
            return 0;
        }
        return 0;
    }

    public int executorMemoryInMb(SparkConf conf) {
        return BoxesRunTime.unboxToInt((Object)conf.getOption(package$.MODULE$.EXECUTOR_MEMORY().key()).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("SPARK_EXECUTOR_MEMORY"))).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("SPARK_MEM")).map((Function1 & Serializable)value -> MODULE$.warnSparkMem((String)value))).map((Function1 & Serializable)str -> BoxesRunTime.boxToInteger((int)Utils$.MODULE$.memoryStringToMb(str))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1024));
    }

    private String warnSparkMem(String value) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Using SPARK_MEM to set amount of memory to use per executor process is deprecated, please use spark.executor.memory instead.");
        return value;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master) {
        Tuple2 tuple2;
        Option option;
        Option option2;
        Option option3;
        Option option4;
        int MAX_LOCAL_TASK_FAILURES = 1;
        String string = master;
        if ("local".equals(string)) {
            SparkContext$.checkResourcesPerTask$1(1, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend2 = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
            scheduler.initialize(backend2);
            return new Tuple2((Object)backend2, (Object)scheduler);
        }
        if (string != null && !(option4 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(1) == 0) {
            int threadCount;
            String threads;
            String string2 = threads = (String)((LinearSeqOps)option4.get()).apply(0);
            String string3 = "*";
            int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? SparkContext$.localCpuCount$1() : (threadCount = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads)));
            if (threadCount <= 0) {
                throw new SparkException("Asked to run locally with " + threadCount + " threads");
            }
            SparkContext$.checkResourcesPerTask$1(threadCount, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend3 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
            scheduler.initialize(backend3);
            return new Tuple2((Object)backend3, (Object)scheduler);
        }
        if (string != null && !(option3 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOps)option3.get()).apply(0);
            String maxFailures = (String)((LinearSeqOps)option3.get()).apply(1);
            String string4 = threads;
            String string5 = "*";
            int threadCount = !(string4 != null ? !string4.equals(string5) : string5 != null) ? SparkContext$.localCpuCount$2() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
            SparkContext$.checkResourcesPerTask$1(threadCount, sc);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(maxFailures)), true, TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
            LocalSchedulerBackend backend4 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
            scheduler.initialize(backend4);
            return new Tuple2((Object)backend4, (Object)scheduler);
        }
        if (string != null && !(option2 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String sparkUrl = (String)((LinearSeqOps)option2.get()).apply(0);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
            String[] masterUrls = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(",")), (Function1 & Serializable)x$68 -> "spark://" + x$68, ClassTag$.MODULE$.apply(String.class));
            StandaloneSchedulerBackend backend5 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
            scheduler.initialize(backend5);
            return new Tuple2((Object)backend5, (Object)scheduler);
        }
        if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String numWorkers = (String)((LinearSeqOps)option.get()).apply(0);
            String coresPerWorker = (String)((LinearSeqOps)option.get()).apply(1);
            String memoryPerWorker = (String)((LinearSeqOps)option.get()).apply(2);
            SparkContext$.checkResourcesPerTask$1(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(coresPerWorker)), sc);
            int memoryPerWorkerInt = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(memoryPerWorker));
            if (sc.executorMemory() > memoryPerWorkerInt) {
                throw new SparkException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MiB/worker but requested %d MiB/executor"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerWorkerInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
            }
            sc.conf().setIfMissing(package$.MODULE$.SHUFFLE_HOST_LOCAL_DISK_READING_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
            LocalSparkCluster localCluster = LocalSparkCluster$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numWorkers)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(coresPerWorker)), memoryPerWorkerInt, sc.conf());
            String[] masterUrls = localCluster.start();
            StandaloneSchedulerBackend backend6 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
            scheduler.initialize(backend6);
            backend6.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)(Function1 & Serializable)backend -> {
                localCluster.stop();
                return BoxedUnit.UNIT;
            });
            return new Tuple2((Object)backend6, (Object)scheduler);
        }
        Option<ExternalClusterManager> option5 = this.getClusterManager(string);
        if (!(option5 instanceof Some)) {
            if (None$.MODULE$.equals(option5)) {
                throw new SparkException("Could not parse Master URL: '" + master + "'");
            }
            throw new MatchError(option5);
        }
        Some some = (Some)option5;
        ExternalClusterManager clusterMgr = (ExternalClusterManager)some.value();
        ExternalClusterManager cm = clusterMgr;
        try {
            TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
            SchedulerBackend backend7 = cm.createSchedulerBackend(sc, string, scheduler);
            cm.initialize(scheduler, backend7);
            tuple2 = new Tuple2((Object)backend7, (Object)scheduler);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof SparkException) {
                SparkException sparkException = (SparkException)throwable3;
                throw sparkException;
            }
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new SparkException("External scheduler cannot be instantiated", throwable2);
            }
            throw throwable;
        }
        return tuple2;
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala().filter((Function1 & Serializable)x$69 -> BoxesRunTime.boxToBoolean((boolean)x$69.canCreate(url)));
        if (serviceLoaders.size() > 1) {
            throw new SparkException("Multiple external cluster managers registered for the url " + url + ": " + serviceLoaders);
        }
        return serviceLoaders.headOption();
    }

    public void org$apache$spark$SparkContext$$enableMagicCommitterIfNeeded(SparkConf conf) {
        if (Utils$.MODULE$.classIsLoadable("org.apache.spark.internal.io.cloud.BindingParquetOutputCommitter") && Utils$.MODULE$.classIsLoadable("org.apache.spark.internal.io.cloud.PathOutputCommitProtocol")) {
            conf.setIfMissing("spark.hadoop.fs.s3a.committer.magic.enabled", "true");
            if (conf.get("spark.hadoop.fs.s3a.committer.magic.enabled").equals("true")) {
                conf.setIfMissing("spark.hadoop.fs.s3a.committer.name", "magic");
                conf.setIfMissing("spark.hadoop.mapreduce.outputcommitter.factory.scheme.s3a", "org.apache.hadoop.fs.s3a.commit.S3ACommitterFactory");
                conf.setIfMissing("spark.sql.parquet.output.committer.class", "org.apache.spark.internal.io.cloud.BindingParquetOutputCommitter");
                conf.setIfMissing("spark.sql.sources.commitProtocolClass", "org.apache.spark.internal.io.cloud.PathOutputCommitProtocol");
                return;
            }
            return;
        }
    }

    public void org$apache$spark$SparkContext$$supplementJavaModuleOptions(SparkConf conf) {
        SparkContext$.supplement$1("spark.driver.extraJavaOptions", conf);
        SparkContext$.supplement$1("spark.executor.extraJavaOptions", conf);
    }

    public void org$apache$spark$SparkContext$$supplementJavaIPv6Options(SparkConf conf) {
        SparkContext$.supplement$2("spark.driver.extraJavaOptions", conf);
        SparkContext$.supplement$2("spark.executor.extraJavaOptions", conf);
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$1(SparkContext sc$1, SparkContext x$65) {
        return x$65 != sc$1;
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$3(SparkContext sc$1, SparkContext x$66) {
        return x$66 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$4(SparkContext otherContext) {
        String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1 & Serializable)x$67 -> x$67.longForm()).getOrElse((Function0 & Serializable)() -> "unknown location");
        MessageWithContext warnMsg = MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Another SparkContext is being constructed (or threw an exception in its"}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" constructor). This may indicate an error, since only one SparkContext should be"}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" running in this JVM (see SPARK-2243)."}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" The other SparkContext was created at:\\n"}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CREATION_SITE, otherContextCreationSite)})));
        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> warnMsg));
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Runtime.getRuntime().availableProcessors();
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
    }

    private static final void checkResourcesPerTask$1(int executorCores, SparkContext sc$2) {
        int taskCores = BoxesRunTime.unboxToInt((Object)sc$2.conf().get(package$.MODULE$.CPUS_PER_TASK()));
        Object object = !BoxesRunTime.unboxToBoolean((Object)sc$2.conf().get(Tests$.MODULE$.SKIP_VALIDATE_CORES_TESTING())) ? BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.MODULE$.validateTaskCpusLargeEnough(sc$2.conf(), executorCores, taskCores)) : BoxedUnit.UNIT;
        ResourceProfile defaultProf = sc$2.resourceProfileManager().defaultResourceProfile();
        ResourceUtils$.MODULE$.warnOnWastedResources(defaultProf, sc$2.conf(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)executorCores)));
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final void supplement$1(String key, SparkConf conf$5) {
        String v = (JavaModuleOptions.defaultModuleOptions() + " " + conf$5.get(key, "")).trim();
        conf$5.set(key, v);
    }

    private static final void supplement$2(String key, SparkConf conf$6) {
        String v = ("-Djava.net.preferIPv6Addresses=" + Utils$.MODULE$.preferIPv6() + " " + conf$6.get(key, "")).trim();
        conf$6.set(key, v);
    }

    private SparkContext$() {
    }
}

