/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.st.ExpressionDefaults$;
import org.apache.spark.sql.catalyst.expressions.st.ST_GeogFromWKB$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(wkb) - Parses the WKB description of a geography and returns the corresponding GEOGRAPHY value.", arguments="\n    Arguments:\n      * wkb - A BINARY value in WKB format, representing a GEOGRAPHY value.\n  ", examples="\n    Examples:\n      > SELECT hex(st_asbinary(_FUNC_(X'0101000000000000000000F03F0000000000000040')));\n       0101000000000000000000F03F0000000000000040\n  ", since="4.1.0", group="st_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\r\u001b\u0001&B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005U!)q\n\u0001C\u0001!\")A\u000b\u0001C!+\"Aq\f\u0001EC\u0002\u0013\u0005S\nC\u0003a\u0001\u0011\u0005\u0013\rC\u0003k\u0001\u0011\u0005S\nC\u0003l\u0001\u0011EC\u000eC\u0004p\u0001\u0005\u0005I\u0011\u00019\t\u000fI\u0004\u0011\u0013!C\u0001g\"9a\u0010AA\u0001\n\u0003z\b\"CA\b\u0001\u0005\u0005I\u0011AA\t\u0011%\tI\u0002AA\u0001\n\u0003\tY\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0011\u0002*!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C!\u0003\u000bB\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\b\u0013\u0005U$$!A\t\u0002\u0005]d\u0001C\r\u001b\u0003\u0003E\t!!\u001f\t\r=\u001bB\u0011AAI\u0011%\t\u0019jEA\u0001\n\u000b\n)\nC\u0005\u0002\u0018N\t\t\u0011\"!\u0002\u001a\"I\u0011QT\n\u0002\u0002\u0013\u0005\u0015q\u0014\u0005\n\u0003W\u001b\u0012\u0011!C\u0005\u0003[\u0013ab\u0015+`\u000f\u0016|wM\u0012:p[^[%I\u0003\u0002\u001c9\u0005\u00111\u000f\u001e\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M9\u0001A\u000b\u00182ii\u0002\u0005CA\u0016-\u001b\u0005a\u0012BA\u0017\u001d\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003WIJ!a\r\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042!\u000e\u001d+\u001b\u00051$BA\u001c\u001f\u0003\u0015!(/Z3t\u0013\tIdGA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t9\u0001K]8ek\u000e$\bCA!J\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002FQ\u00051AH]8pizJ\u0011!P\u0005\u0003\u0011r\nq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\nP\u0001\u0004o.\u0014W#\u0001\u0016\u0002\t]\\'\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u001b\u0006C\u0001*\u0001\u001b\u0005Q\u0002\"\u0002'\u0004\u0001\u0004Q\u0013AC5oaV$H+\u001f9fgV\ta\u000bE\u0002B/fK!\u0001W&\u0003\u0007M+\u0017\u000f\u0005\u0002[;6\t1L\u0003\u0002]A\u0005)A/\u001f9fg&\u0011al\u0017\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1B]3qY\u0006\u001cW-\\3oi\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\t\u0004\"aY4\u000f\u0005\u0011,\u0007CA\"=\u0013\t1G(\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014=\u0003\u0015\u0019\u0007.\u001b7e\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0011\u0011+\u001c\u0005\u0006]\"\u0001\rAK\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\t\t\u0016\u000fC\u0004M\u0013A\u0005\t\u0019\u0001\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAO\u000b\u0002+k.\na\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003wr\n!\"\u00198o_R\fG/[8o\u0013\ti\bPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\tA\u0001\\1oO*\u0011\u00111B\u0001\u0005U\u00064\u0018-C\u0002i\u0003\u000b\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0005\u0011\u0007m\n)\"C\u0002\u0002\u0018q\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\b\u0002$A\u00191(a\b\n\u0007\u0005\u0005BHA\u0002B]fD\u0011\"!\n\u000e\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0003\u0005\u0004\u0002.\u0005M\u0012QD\u0007\u0003\u0003_Q1!!\r=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\tyC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0003\u0003\u00022aOA\u001f\u0013\r\ty\u0004\u0010\u0002\b\u0005>|G.Z1o\u0011%\t)cDA\u0001\u0002\u0004\ti\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0001\u0003\u000fB\u0011\"!\n\u0011\u0003\u0003\u0005\r!a\u0005\u0002\r\u0015\fX/\u00197t)\u0011\tY$!\u0014\t\u0013\u0005\u0015\u0012#!AA\u0002\u0005u\u0001f\u0006\u0001\u0002R\u0005]\u0013\u0011LA/\u0003?\n\u0019'!\u001a\u0002j\u0005-\u0014qNA9!\rY\u00131K\u0005\u0004\u0003+b\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\nam\u0018$V\u001d\u000e{\u0006f^6cS\u0001j\u0003\u0005U1sg\u0016\u001c\b\u0005\u001e5fA][%\t\t3fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004sN\u001a\u0011bA\u001d,wn\u001a:ba\"L\b%\u00198eAI,G/\u001e:og\u0002\"\b.\u001a\u0011d_J\u0014Xm\u001d9p]\u0012Lgn\u001a\u0011H\u000b>;%+\u0011)I3\u00022\u0018\r\\;f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003C\naL\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!o.\u0014\u0007%\f\u0011BA\tKe*\u0011*ZAY\fG.^3!S:\u0004sk\u0013\"!M>\u0014X.\u0019;-AI,\u0007O]3tK:$\u0018N\\4!C\u0002:UiT$S\u0003BC\u0015\f\t<bYV,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA4\u0003\u0005]\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t5fq\"\u001aHoX1tE&t\u0017M]=)?\u001a+fjQ0)1\u001e\u0002\u0014\u0007M\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002d\tM\u001aGaA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191iA:\u0013&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AA\n\u0004'\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA2\u0005g\r$1aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00195a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002n\u0005)AGL\u0019/a\u0005)qM]8va\u0006\u0012\u00111O\u0001\tgR|f-\u001e8dg\u0006q1\u000bV0HK><gI]8n/.\u0013\u0005C\u0001*\u0014'\u0015\u0019\u00121PAD!\u0019\ti(a!+#6\u0011\u0011q\u0010\u0006\u0004\u0003\u0003c\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\u000byHA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000bI!\u0001\u0002j_&\u0019!*a#\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0011!B1qa2LHcA)\u0002\u001c\")AJ\u0006a\u0001U\u00059QO\\1qa2LH\u0003BAQ\u0003O\u0003BaOARU%\u0019\u0011Q\u0015\u001f\u0003\r=\u0003H/[8o\u0011!\tIkFA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0016\t\u0005\u0003\u0007\t\t,\u0003\u0003\u00024\u0006\u0015!AB(cU\u0016\u001cG\u000f")
public class ST_GeogFromWKB
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
UnaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression wkb;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Expression> unapply(ST_GeogFromWKB x$0) {
        return ST_GeogFromWKB$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ST_GeogFromWKB, A> g) {
        return ST_GeogFromWKB$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ST_GeogFromWKB> compose(Function1<A$, Expression> g) {
        return ST_GeogFromWKB$.MODULE$.compose(g);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression wkb() {
        return this.wkb;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    private Expression replacement$lzycompute() {
        ST_GeogFromWKB sT_GeogFromWKB = this;
        synchronized (sT_GeogFromWKB) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Class<STUtils> x$1 = STUtils.class;
                GeographyType x$2 = GeographyType$.MODULE$.apply(ExpressionDefaults$.MODULE$.DEFAULT_GEOGRAPHY_SRID());
                String x$3 = "stGeogFromWKB";
                .colon.colon x$4 = new .colon.colon((Object)this.wkb(), (List)Nil$.MODULE$);
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                this.replacement = new StaticInvoke(STUtils.class, (DataType)x$2, "stGeogFromWKB", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "st_geogfromwkb";
    }

    @Override
    public Expression child() {
        return this.wkb();
    }

    @Override
    public ST_GeogFromWKB withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ST_GeogFromWKB copy(Expression wkb) {
        return new ST_GeogFromWKB(wkb);
    }

    public Expression copy$default$1() {
        return this.wkb();
    }

    @Override
    public String productPrefix() {
        return "ST_GeogFromWKB";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.wkb();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_GeogFromWKB;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "wkb";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_GeogFromWKB)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_GeogFromWKB sT_GeogFromWKB = (ST_GeogFromWKB)x$1;
        Expression expression = this.wkb();
        Expression expression2 = sT_GeogFromWKB.wkb();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sT_GeogFromWKB.canEqual(this)) return false;
        return true;
    }

    public ST_GeogFromWKB(Expression wkb) {
        this.wkb = wkb;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        Statics.releaseFence();
    }
}

