/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateSub$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(start_date, num_days) - Returns the date that is `num_days` before `start_date`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-07-30', 1);\n       2016-07-29\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011K\u0011\u0015a\u0006\u0001\"\u0011K\u0011\u0015i\u0006\u0001\"\u0011X\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\t\u0001\t#\n\u0019\u0003C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u0011Q\u0007\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001b\u0002\u0011\u0013!C\u0001\u0003oA\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA6\u0001\u0005\u0005I\u0011AA7\u0011%\t\u0019\bAA\u0001\n\u0003\n)\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u0003\u001f\u0003\u0011\u0011!C!\u0003#;\u0011\"!.#\u0003\u0003E\t!a.\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003sCa!U\u000e\u0005\u0002\u0005E\u0007\"CAj7\u0005\u0005IQIAk\u0011%\t9nGA\u0001\n\u0003\u000bI\u000eC\u0005\u0002`n\t\t\u0011\"!\u0002b\"I\u00111_\u000e\u0002\u0002\u0013%\u0011Q\u001f\u0002\b\t\u0006$XmU;c\u0015\t\u0019C%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0013'\u0003!\u0019\u0017\r^1msN$(BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011#\u0002\u00011i]j\u0004CA\u00193\u001b\u0005\u0011\u0013BA\u001a#\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00022k%\u0011aG\t\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$a\u0002)s_\u0012,8\r\u001e\t\u0003}\u0019s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\ts\u0013A\u0002\u001fs_>$h(C\u0001;\u0013\t)\u0015(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%\u0001D*fe&\fG.\u001b>bE2,'BA#:\u0003%\u0019H/\u0019:u\t\u0006$X-F\u0001L!\t\tD*\u0003\u0002NE\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0015M$\u0018M\u001d;ECR,\u0007%\u0001\u0003eCf\u001c\u0018!\u00023bsN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"!\r\u0001\t\u000b%+\u0001\u0019A&\t\u000b=+\u0001\u0019A&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0001\f\u0005\u000293&\u0011!,\u000f\u0002\b\u0005>|G.Z1o\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u00025\r|g\u000e^3yi&sG-\u001a9f]\u0012,g\u000e\u001e$pY\u0012\f'\r\\3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001a!\rq\u0014mY\u0005\u0003E\"\u00131aU3r!\t!w-D\u0001f\u0015\t1g%A\u0003usB,7/\u0003\u0002iK\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t1\u000e\u0005\u0002eY&\u0011Q.\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001o];\u0011\u0005a\n\u0018B\u0001::\u0005\r\te.\u001f\u0005\u0006i2\u0001\r\u0001]\u0001\u0006gR\f'\u000f\u001e\u0005\u0006m2\u0001\r\u0001]\u0001\u0002I\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005s~\fI\u0001\u0005\u0002{{6\t1P\u0003\u0002}E\u000591m\u001c3fO\u0016t\u0017B\u0001@|\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0001\u001b\u0001\u0007\u00111A\u0001\u0004GRD\bc\u0001>\u0002\u0006%\u0019\u0011qA>\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111B\u0007A\u0002e\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0012A!\u00111CA\u000e\u001d\u0011\t)\"a\u0006\u0011\u0005\u0001K\u0014bAA\rs\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007:\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003T\u0003K\tI\u0003\u0003\u0004\u0002(=\u0001\raS\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tYc\u0004a\u0001\u0017\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B*\u00022\u0005M\u0002bB%\u0011!\u0003\u0005\ra\u0013\u0005\b\u001fB\u0001\n\u00111\u0001L\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u000f+\u0007-\u000bYd\u000b\u0002\u0002>A!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013!C;oG\",7m[3e\u0015\r\t9%O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA&\u0003\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\nA\u0001\\1oO*\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005]\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA3!\rA\u0014qM\u0005\u0004\u0003SJ$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00019\u0002p!I\u0011\u0011O\u000b\u0002\u0002\u0003\u0007\u0011QM\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0004#BA=\u0003\u007f\u0002XBAA>\u0015\r\ti(O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAA\u0003w\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001,a\"\t\u0011\u0005Et#!AA\u0002A\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111KAG\u0011%\t\t\bGA\u0001\u0002\u0004\t)'\u0001\u0004fcV\fGn\u001d\u000b\u00041\u0006M\u0005\u0002CA93\u0005\u0005\t\u0019\u00019)'\u0001\t9*!(\u0002 \u0006\r\u0016QUAU\u0003W\u000by+!-\u0011\u0007E\nI*C\u0002\u0002\u001c\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\"\u00069vLR+O\u0007~C3\u000f^1si~#\u0017\r^3-A9,Xn\u00183bsNL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005Z1uK\u0002\"\b.\u0019;!SN\u0004\u0003M\\;n?\u0012\f\u0017p\u001d1!E\u00164wN]3!AN$\u0018M\u001d;`I\u0006$X\r\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a*\u0002\u0017*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002t'L\u001a1O1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'\f\u00198[IJ$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u00055\u0016A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003g\u000bQ!\r\u00186]A\nq\u0001R1uKN+(\r\u0005\u000227M)1$a/\u0002HB9\u0011QXAb\u0017.\u001bVBAA`\u0015\r\t\t-O\u0001\beVtG/[7f\u0013\u0011\t)-a0\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002J\u0006=WBAAf\u0015\u0011\ti-a\u0017\u0002\u0005%|\u0017bA$\u0002LR\u0011\u0011qW\u0001\ti>\u001cFO]5oOR\u0011\u00111K\u0001\u0006CB\u0004H.\u001f\u000b\u0006'\u0006m\u0017Q\u001c\u0005\u0006\u0013z\u0001\ra\u0013\u0005\u0006\u001fz\u0001\raS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019/a<\u0011\u000ba\n)/!;\n\u0007\u0005\u001d\u0018H\u0001\u0004PaRLwN\u001c\t\u0006q\u0005-8jS\u0005\u0004\u0003[L$A\u0002+va2,'\u0007\u0003\u0005\u0002r~\t\t\u00111\u0001T\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003o\u0004B!!\u0016\u0002z&!\u00111`A,\u0005\u0019y%M[3di\u0002")
public class DateSub
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression days;

    public static Option<Tuple2<Expression, Expression>> unapply(DateSub x$0) {
        return DateSub$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, DateSub> tupled() {
        return DateSub$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, DateSub>> curried() {
        return DateSub$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression days() {
        return this.days;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.days();
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contextIndependentFoldable()));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$})), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object d) {
        return BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)start) - ((Number)d).intValue()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(sd, d) -> ev.value() + " = " + sd + " - " + d + ";");
    }

    @Override
    public String prettyName() {
        return "date_sub";
    }

    @Override
    public DateSub withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public DateSub copy(Expression startDate, Expression days) {
        return new DateSub(startDate, days);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.days();
    }

    @Override
    public String productPrefix() {
        return "DateSub";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.startDate();
            }
            case 1: {
                return this.days();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateSub;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "startDate";
            }
            case 1: {
                return "days";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateSub)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateSub dateSub = (DateSub)x$1;
        Expression expression = this.startDate();
        Expression expression2 = dateSub.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.days();
        Expression expression4 = dateSub.days();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!dateSub.canEqual(this)) return false;
        return true;
    }

    public DateSub(Expression startDate, Expression days) {
        this.startDate = startDate;
        this.days = days;
        ExpectsInputTypes.$init$(this);
    }
}

