/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsRowLevelOperations;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;

public final class ResolveMergeIntoSchemaEvolution$
extends Rule<LogicalPlan> {
    public static final ResolveMergeIntoSchemaEvolution$ MODULE$ = new ResolveMergeIntoSchemaEvolution$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                MergeIntoTable mergeIntoTable;
                A1 A1 = x1;
                if (A1 instanceof MergeIntoTable && (mergeIntoTable = (MergeIntoTable)A1).evaluateSchemaEvolution()) {
                    TableChange[] changes = mergeIntoTable.changesForSchemaEvolution();
                    if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])changes))) {
                        return (B1)mergeIntoTable;
                    }
                    return (B1)mergeIntoTable.transformUpWithNewOutput((PartialFunction)new Serializable(null, mergeIntoTable, changes){
                        private static final long serialVersionUID = 0L;
                        private final MergeIntoTable x2$1;
                        private final TableChange[] changes$1;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            DataSourceV2Relation dataSourceV2Relation;
                            A1 A1 = x1;
                            if (A1 instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)A1).table() instanceof SupportsRowLevelOperations) {
                                StructType referencedSourceSchema = MergeIntoTable$.MODULE$.sourceSchemaForSchemaEvolution(this.x2$1);
                                DataSourceV2Relation newTarget = ResolveMergeIntoSchemaEvolution$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveMergeIntoSchemaEvolution$$performSchemaEvolution(dataSourceV2Relation, referencedSourceSchema, this.changes$1);
                                Seq<Attribute> oldTargetOutput = this.x2$1.targetTable().output();
                                Seq<AttributeReference> newTargetOutput = newTarget.output();
                                Seq attributeMapping = (Seq)oldTargetOutput.zip(newTargetOutput);
                                return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newTarget), (Object)attributeMapping);
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(LogicalPlan x1) {
                            DataSourceV2Relation dataSourceV2Relation;
                            LogicalPlan logicalPlan = x1;
                            return logicalPlan instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).table() instanceof SupportsRowLevelOperations;
                        }
                        {
                            this.x2$1 = x2$1;
                            this.changes$1 = changes$1;
                        }
                    }, (Function1)mergeIntoTable.transformUpWithNewOutput$default$2(), (Function1)mergeIntoTable.transformUpWithNewOutput$default$3());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                MergeIntoTable mergeIntoTable;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof MergeIntoTable && (mergeIntoTable = (MergeIntoTable)logicalPlan).evaluateSchemaEvolution();
            }
        });
    }

    public DataSourceV2Relation org$apache$spark$sql$catalyst$analysis$ResolveMergeIntoSchemaEvolution$$performSchemaEvolution(DataSourceV2Relation relation, StructType referencedSourceSchema, TableChange[] changes) {
        Tuple2 tuple2 = new Tuple2(relation.catalog(), relation.identifier());
        if (tuple2 != null) {
            Some some;
            CatalogPlugin c;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && (c = (CatalogPlugin)(some = (Some)option).value()) instanceof TableCatalog) {
                TableCatalog tableCatalog = (TableCatalog)c;
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Identifier i = (Identifier)some2.value();
                    tableCatalog.alterTable(i, changes);
                    Table newTable = tableCatalog.loadTable(i);
                    StructType newSchema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(newTable.columns());
                    TableChange[] remainingChanges = MergeIntoTable$.MODULE$.schemaChanges(newSchema, referencedSourceSchema, MergeIntoTable$.MODULE$.schemaChanges$default$3());
                    if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])remainingChanges))) {
                        throw QueryCompilationErrors$.MODULE$.unsupportedTableChangesInAutoSchemaEvolutionError(remainingChanges, CatalogV2Implicits$.MODULE$.IdentifierHelper(i).toQualifiedNameParts(tableCatalog));
                    }
                    return relation.copy(newTable, DataTypeUtils$.MODULE$.toAttributes(newSchema), relation.copy$default$3(), relation.copy$default$4(), relation.copy$default$5(), relation.copy$default$6());
                }
            }
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Schema Evolution enabled but data source " + relation + " does not support it, skipping.");
        return relation;
    }

    private ResolveMergeIntoSchemaEvolution$() {
    }
}

