/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.util.Set;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;

public abstract class ModelUtils {
    public static org.apache.maven.artifact.Artifact getArtifact(MavenProject project, MavenSession session, ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        Set artifacts = project.getDependencyArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId) || !artifact.getVersion().equals(version) || !artifact.getType().equals(type) || (classifier != null || artifact.getClassifier() != null) && (classifier == null || !classifier.equals(artifact.getClassifier()))) continue;
            return artifact;
        }
        DefaultArtifact prjArtifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "provided", type, classifier, artifactHandlerManager.getArtifactHandler(type));
        try {
            resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to get artifact for " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to get artifact for " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        return prjArtifact;
    }

    public static Artifact findBaseArtifact(Model model) throws MavenExecutionException {
        Feature base = model.getFeature(":launchpad");
        if (base == null) {
            throw new MavenExecutionException("No launchpad feature found.", (File)null);
        }
        RunMode runMode = base.getRunMode(new String[0]);
        if (runMode == null) {
            throw new MavenExecutionException("No global run mode found in launchpad feature.", (File)null);
        }
        if (runMode.getArtifactGroups().isEmpty()) {
            throw new MavenExecutionException("No base artifacts defined.", (File)null);
        }
        if (runMode.getArtifactGroups().size() > 1) {
            throw new MavenExecutionException("Base run mode should only have a single start level.", (File)null);
        }
        Artifact firstArtifact = null;
        for (Artifact a : (ArtifactGroup)runMode.getArtifactGroups().get(0)) {
            if (firstArtifact == null) {
                firstArtifact = a;
                continue;
            }
            throw new MavenExecutionException("Base run mode should contain exactly one artifact: " + runMode.getArtifactGroups().get(0), (File)null);
        }
        if (firstArtifact == null) {
            throw new MavenExecutionException("No base artifacts defined.", (File)null);
        }
        return firstArtifact;
    }

    public static String toString(Dependency d) {
        return "Dependency {groupId=" + d.getGroupId() + ", artifactId=" + d.getArtifactId() + ", version=" + d.getVersion() + (d.getClassifier() != null ? ", classifier=" + d.getClassifier() : "") + ", type=" + d.getType() + "}";
    }
}

