/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.validation.model.ValidatorInvocation;

public class ValidatorInvocationImpl
implements ValidatorInvocation {
    @Nonnull
    private final String id;
    @Nonnull
    private final Map<String, Object> parameters;
    private final Integer severity;

    public ValidatorInvocationImpl(@Nonnull String id, @Nonnull Map<String, Object> parameters, Integer severity) {
        this.id = id;
        this.parameters = parameters;
        this.severity = severity;
    }

    public String getValidatorId() {
        return this.id;
    }

    @Nonnull
    public ValueMap getParameters() {
        return new ValueMapDecorator(this.parameters);
    }

    @CheckForNull
    public Integer getSeverity() {
        return this.severity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorInvocationImpl other = (ValidatorInvocationImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.severity == null ? other.severity != null : !this.severity.equals(other.severity));
    }

    public String toString() {
        return "ParameterizedValidatorImpl [id=" + this.id + ", parameters=" + this.parameters + ", severity=" + this.severity + "]";
    }
}

