/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.sling.tooling.support.source.impl.PomHandler;
import org.apache.sling.tooling.support.source.impl.SourceReference;
import org.apache.sling.tooling.support.source.impl.SourceReferenceException;
import org.apache.sling.tooling.support.source.impl.SourceReferenceFinder;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FelixJettySourceReferenceFinder
implements SourceReferenceFinder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    @Override
    public List<SourceReference> findSourceReferences(Bundle bundle) throws SourceReferenceException {
        if (!"org.apache.felix.http.jetty".equals(bundle.getSymbolicName())) {
            return Collections.emptyList();
        }
        Object jettyVersion = bundle.getHeaders().get("X-Jetty-Version");
        if (!(jettyVersion instanceof String)) {
            this.log.warn("Could not retrieve Jetty version from bundle '{}' because header 'X-Jetty-Version' is not set!", (Object)bundle);
            return Collections.emptyList();
        }
        Enumeration entries = bundle.findEntries("META-INF/maven", "pom.xml", true);
        if (entries != null && entries.hasMoreElements()) {
            List<SourceReference> list;
            block11: {
                URL entry = (URL)entries.nextElement();
                InputStream pom = entry.openStream();
                try {
                    SAXParser parser = this.parserFactory.newSAXParser();
                    PomHandler handler = new PomHandler((String)jettyVersion);
                    parser.parse(new InputSource(pom), (DefaultHandler)handler);
                    list = handler.getReferences();
                    if (pom == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (pom != null) {
                            try {
                                pom.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        throw new SourceReferenceException(e);
                    }
                }
                pom.close();
            }
            return list;
        }
        this.log.warn("Could not find a pom.xml in bundle '{}'!", (Object)bundle);
        return Collections.emptyList();
    }
}

