/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.maintenance.internal;

import javax.management.openmbean.CompositeData;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.sling.jcr.maintenance.RepositoryManagementUtil;
import org.apache.sling.jcr.maintenance.RunnableJob;
import org.apache.sling.jcr.maintenance.internal.DataStoreCleanupScheduler;
import org.apache.sling.jcr.maintenance.internal.RevisionCleanupScheduler;
import org.apache.sling.jcr.maintenance.internal.VersionCleanupMBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={HealthCheck.class}, property={"hc.tags=oak", "hc.tags=system-resource", "hc.name=Apache Sling JCR Maintenance"}, immediate=true)
public class RepositoryMaintenanceHealthCheck
implements HealthCheck {
    private DataStoreCleanupScheduler dataStoreCleanupScheduler;
    private RevisionCleanupScheduler revisionCleanupScheduler;
    private RepositoryManagementMBean repositoryManagementMBean;
    private VersionCleanupMBean versionCleanup;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, service=Runnable.class, target="(component.name=org.apache.sling.jcr.maintenance.internal.DataStoreCleanupScheduler)")
    public void setDataStoreCleanupScheduler(Runnable dataStoreCleanupScheduler) {
        this.dataStoreCleanupScheduler = (DataStoreCleanupScheduler)dataStoreCleanupScheduler;
    }

    @Reference
    public void setRepositoryManagementMBean(RepositoryManagementMBean repositoryManagementMBean) {
        this.repositoryManagementMBean = repositoryManagementMBean;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, service=Runnable.class, target="(component.name=org.apache.sling.jcr.maintenance.internal.RevisionCleanupScheduler)")
    public void setRevisionCleanupScheduler(Runnable revisionCleanupScheduler) {
        this.revisionCleanupScheduler = (RevisionCleanupScheduler)revisionCleanupScheduler;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    public void setVersionCleanup(VersionCleanupMBean versionCleanup) {
        this.versionCleanup = versionCleanup;
    }

    private void evaluateJobStatus(FormattingResultLog log, String jobName, RunnableJob job, CompositeData status) {
        if (job != null) {
            log.debug("{} Schedule: {}", new Object[]{jobName, job.getSchedulerExpression()});
        } else {
            log.warn("{} not registered", new Object[]{jobName});
        }
        if (RepositoryManagementUtil.isValid(status)) {
            log.debug("{} Last Status: {}", new Object[]{jobName, RepositoryManagementUtil.getStatusCode(status).name()});
            log.debug("{} Last Message: {}", new Object[]{jobName, RepositoryManagementUtil.getMessage(status)});
        } else {
            log.critical("{} Last Status: {}", new Object[]{jobName, RepositoryManagementUtil.getStatusCode(status).name()});
            log.critical("{} Last Message: {}", new Object[]{jobName, RepositoryManagementUtil.getMessage(status)});
        }
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        this.evaluateJobStatus(log, "DataStoreCleanupScheduler", this.dataStoreCleanupScheduler, this.repositoryManagementMBean.getDataStoreGCStatus());
        this.evaluateJobStatus(log, "RevisionCleanupScheduler", this.revisionCleanupScheduler, this.repositoryManagementMBean.getRevisionGCStatus());
        if (this.versionCleanup != null) {
            if (this.versionCleanup.isFailed()) {
                log.critical("VersionCleanup Status: FAILED", new Object[0]);
                log.critical("VersionCleanup Message: {}", new Object[]{this.versionCleanup.getLastMessage()});
            } else {
                log.debug("VersionCleanup Status: SUCCEEDED", new Object[0]);
            }
            log.debug("VersionCleanup Last Cleaned: {}", new Object[]{this.versionCleanup.getLastCleanedVersionsCount()});
        } else {
            log.warn("VersionCleanup not registered", new Object[0]);
        }
        return new Result((ResultLog)log);
    }
}

