/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

class RescanTimer {
    public static final long DEFAULT_SCAN_DELAY_MSEC = 500L;
    private long nextScanTime = Long.MAX_VALUE;
    private final long scanDelay;

    RescanTimer(long scanDelayMsec) {
        this.scanDelay = scanDelayMsec;
    }

    RescanTimer() {
        this(500L);
    }

    synchronized void scheduleScan() {
        this.nextScanTime = System.currentTimeMillis() + this.scanDelay;
    }

    synchronized void reset() {
        this.nextScanTime = Long.MAX_VALUE;
    }

    boolean expired() {
        return System.currentTimeMillis() > this.nextScanTime;
    }
}

