/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FolderNameFilter {
    private final Pattern pattern;
    private final String regexp;
    private final SlingSettingsService slingSettings;
    private final String[] rootPaths;
    private final Map<String, Integer> rootPriorities = new HashMap<String, Integer>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int RUNMODE_PRIORITY_BOOST = 1;
    public static final int DEFAULT_ROOT_PRIORITY = 99;

    FolderNameFilter(String[] rootsConfig, String regexp, SlingSettingsService slingSettings) {
        ArrayList<RootPathInfo> rootPathInfos = new ArrayList<RootPathInfo>();
        this.regexp = regexp;
        this.pattern = Pattern.compile(regexp);
        this.slingSettings = slingSettings;
        this.rootPaths = new String[rootsConfig.length];
        for (int i = 0; i < rootsConfig.length; ++i) {
            String[] parts = rootsConfig[i].split(":");
            this.rootPaths[i] = FolderNameFilter.cleanupRootPath(parts[0]);
            Integer priority = new Integer(99);
            if (parts.length > 1) {
                try {
                    priority = Integer.parseInt(parts[1].trim());
                }
                catch (NumberFormatException nfe) {
                    this.log.warn("Invalid priority in path definition '{}'", (Object)rootsConfig[i]);
                }
            }
            this.rootPriorities.put(this.rootPaths[i], priority);
            rootPathInfos.add(new RootPathInfo(this.rootPaths[i], priority));
            this.log.debug("Root path {} has priority {}", (Object)this.rootPaths[i], (Object)priority);
        }
        Collections.sort(rootPathInfos);
        int index = 0;
        for (RootPathInfo rpi : rootPathInfos) {
            this.rootPaths[index++] = rpi.path;
        }
    }

    String[] getRootPaths() {
        return this.rootPaths;
    }

    static String cleanupRootPath(String str) {
        String result = str.trim();
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    int getPriority(String path) {
        int result = 0;
        boolean match = false;
        int DOT = 46;
        String prefix = path;
        int lastSlash = prefix.lastIndexOf(47);
        if (lastSlash > 0) {
            prefix = prefix.substring(lastSlash);
        }
        String modes = null;
        if (prefix.indexOf(46) > 0) {
            int pos = 0;
            String pathAndRunmodes = prefix;
            while ((pos = prefix.lastIndexOf(46)) >= 0) {
                if (!this.pattern.matcher(prefix = prefix.substring(0, pos)).matches()) continue;
                result = this.getRootPriority(path);
                break;
            }
            if (result > 0) {
                modes = pathAndRunmodes.substring(pos + 1);
                int runModeMatchCount = this.slingSettings.getBestRunModeMatchCountFromSpec(modes);
                result = runModeMatchCount > 0 ? (result += 1 * runModeMatchCount) : 0;
            }
        } else if (this.pattern.matcher(path).matches()) {
            match = true;
            result = this.getRootPriority(path);
        }
        if (modes != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("getPriority(" + path + ")=" + result + " (prefix=" + prefix + ", run modes=" + modes + ")");
            }
        } else if (match) {
            this.log.debug("getPriority({})={}", (Object)path, (Object)result);
        } else {
            this.log.debug("getPriority({})={}, path doesn't match regexp", (Object)path, (Object)result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.regexp + "), active run modes=" + this.slingSettings.getRunModes();
    }

    int getRootPriority(String path) {
        for (Map.Entry<String, Integer> e : this.rootPriorities.entrySet()) {
            if (!path.startsWith(e.getKey())) continue;
            return e.getValue();
        }
        return 0;
    }

    private static final class RootPathInfo
    implements Comparable<RootPathInfo> {
        public final String path;
        private final Integer priority;

        public RootPathInfo(String path, Integer prio) {
            this.path = path;
            this.priority = prio;
        }

        @Override
        public int compareTo(RootPathInfo o) {
            int result = -this.priority.compareTo(o.priority);
            if (result == 0) {
                result = this.path.compareTo(o.path);
            }
            return result;
        }
    }
}

