/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.subsystems.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.factories.subsystems.impl.SubsystemInstaller;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceTracker<Subsystem, Subsystem> rootSubsystemTracker;
    private ServiceRegistration<?> serviceReg;

    public void start(final BundleContext context) throws Exception {
        this.rootSubsystemTracker = new ServiceTracker(context, context.createFilter("(&(objectClass=" + Subsystem.class.getName() + ")" + "(" + "subsystem.id" + "=0))"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Subsystem, Subsystem>(){

            public Subsystem addingService(ServiceReference<Subsystem> reference) {
                Subsystem service = (Subsystem)context.getService(reference);
                if (service != null) {
                    Activator.this.registerInstaller(context, service);
                }
                return service;
            }

            public void modifiedService(ServiceReference<Subsystem> reference, Subsystem service) {
            }

            public void removedService(ServiceReference<Subsystem> reference, Subsystem service) {
                Activator.this.unregisterInstaller();
            }
        });
        this.rootSubsystemTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.rootSubsystemTracker != null) {
            this.rootSubsystemTracker.close();
            this.rootSubsystemTracker = null;
        }
        this.unregisterInstaller();
    }

    private void registerInstaller(BundleContext context, Subsystem rootSubsystem) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Installer Support for Subsystems");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.serviceReg = context.registerService(new String[]{ResourceTransformer.class.getName(), InstallTaskFactory.class.getName()}, (Object)new SubsystemInstaller(rootSubsystem, context), props);
    }

    private void unregisterInstaller() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
    }
}

