/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.ide.impl.vlt.JcrCommand;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;

public class ListTreeCommand
extends JcrCommand<ResourceProxy> {
    private final int levels;

    public ListTreeCommand(Repository repository, Credentials credentials, RepositoryPath path, int levels, Logger logger) {
        super(repository, credentials, path, logger, new Repository.CommandExecutionFlag[0]);
        this.levels = Math.max(1, levels);
    }

    @Override
    protected ResourceProxy execute0(Session session) throws RepositoryException {
        Node node = session.getNode(this.getPath().asString());
        ResourceProxy parent = this.nodeToResource(node);
        this.addChildren(parent, node, this.levels - 1);
        return parent;
    }

    private void addChildren(ResourceProxy parent, Node node, int remainingLevels) throws RepositoryException {
        if (remainingLevels < 0) {
            throw new IllegalArgumentException("remainingLevels must be >=0, not: " + remainingLevels);
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node childNode = nodes.nextNode();
            if (childNode.getPath().equals("/jcr:system")) continue;
            ResourceProxy childResourceProxy = this.nodeToResource(childNode);
            parent.addChild(childResourceProxy);
            if (remainingLevels <= 0) continue;
            this.addChildren(childResourceProxy, childNode, remainingLevels - 1);
        }
    }
}

