/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.support.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Session;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(service={HealthCheck.class}, name="org.apache.sling.hc.support.ScriptedHealthCheck", configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class ScriptedHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptedHealthCheck.class);
    public static final String HC_LABEL = "Health Check: Sling Script (deprecated)";
    public static final String JCR_FILE_URL_PREFIX = "jcr:";
    private static final String JCR_CONTENT = "/jcr:content";
    private String language;
    private String script;
    private String scriptUrl;
    private BundleContext bundleContext;
    @Reference
    private ScriptEngineManager scriptEngineManager;
    private ScriptHelper scriptHelper = new ScriptHelper();
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Activate
    protected void activate(BundleContext context, Config config) {
        this.bundleContext = context;
        this.language = config.language().toLowerCase();
        this.script = config.script();
        this.scriptUrl = config.scriptUrl();
        if (StringUtils.isNotBlank((CharSequence)this.script) && StringUtils.isNotBlank((CharSequence)this.scriptUrl)) {
            LOG.info("Both 'script' and 'scriptUrl' (={}) are configured, ignoring 'scriptUrl'", (Object)this.scriptUrl);
            this.scriptUrl = null;
        }
        LOG.info("Activated Scripted HC {} with {}", (Object)config.hc_name(), (Object)(StringUtils.isNotBlank((CharSequence)this.script) ? "script " + this.script : "script url " + this.scriptUrl));
        LOG.warn("This is deprecated. Please use the use the equivalent functionality from the org.apache.felix.healthcheck.generalchecks bundle instead.");
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        try (ResourceResolver resourceResolver = null;){
            String scriptToExecute;
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            boolean urlIsUsed = StringUtils.isBlank((CharSequence)this.script);
            if (urlIsUsed) {
                if (this.scriptUrl.startsWith(JCR_FILE_URL_PREFIX)) {
                    String jcrPath = StringUtils.substringAfter((String)this.scriptUrl, (String)JCR_FILE_URL_PREFIX);
                    scriptToExecute = this.getScriptFromRepository(resourceResolver, jcrPath);
                } else {
                    scriptToExecute = this.scriptHelper.getFileContents(this.scriptUrl);
                }
            } else {
                scriptToExecute = this.script;
            }
            log.info("Executing script {} ({} lines)...", new Object[]{urlIsUsed ? this.scriptUrl : " as configured", scriptToExecute.split("\n").length});
            try {
                ScriptEngine scriptEngine = this.getScriptEngine(this.language);
                HashMap<String, Object> additionalBindings = new HashMap<String, Object>();
                additionalBindings.put("resourceResolver", resourceResolver);
                additionalBindings.put("session", resourceResolver.adaptTo(Session.class));
                this.scriptHelper.evalScript(this.bundleContext, scriptEngine, scriptToExecute, log, additionalBindings, true);
            }
            catch (Exception e) {
                log.healthCheckError("Exception while executing script: " + e, new Object[]{e});
            }
            Result result = new Result((ResultLog)log);
            return result;
        }
    }

    private String factoriesToString(List<ScriptEngineFactory> engineFactories) {
        ArrayList<String> factoryArr = new ArrayList<String>();
        for (ScriptEngineFactory ef : engineFactories) {
            factoryArr.add(ef.getEngineName() + " (" + StringUtils.join(ef.getExtensions(), (String)",") + ")");
        }
        return StringUtils.join(factoryArr, (String)", ");
    }

    private ScriptEngine getScriptEngine(String language) {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension(language);
        if (scriptEngine == null) {
            try {
                scriptEngine = this.scriptHelper.getScriptEngine(this.scriptEngineManager, language);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Could not get script engine for " + language + " from available factories: " + this.factoriesToString(this.scriptEngineManager.getEngineFactories()) + ") nor from regular bundles: " + e.getMessage());
            }
        }
        return scriptEngine;
    }

    private String getScriptFromRepository(ResourceResolver resourceResolver, String jcrPath) {
        String fileContent;
        try {
            Resource dataResource = resourceResolver.getResource(jcrPath + JCR_CONTENT);
            if (dataResource == null) {
                throw new IllegalArgumentException("Could not load script from path " + jcrPath);
            }
            try (InputStream is = (InputStream)dataResource.adaptTo(InputStream.class);
                 ByteArrayOutputStream result = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                fileContent = result.toString(StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load script from path " + jcrPath + ": " + e, e);
        }
        return fileContent;
    }

    private static class ScriptHelper {
        private ScriptHelper() {
        }

        public String getFileContents(String url) {
            try {
                String content = Files.readAllLines(Paths.get(new URI(url))).stream().collect(Collectors.joining("\n"));
                return content;
            }
            catch (IOException | URISyntaxException e) {
                throw new IllegalArgumentException("Could not read file URL " + url + ": " + e, e);
            }
        }

        public ScriptEngine getScriptEngine(ScriptEngineManager scriptEngineManager, String language) {
            List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
            ScriptEngine scriptEngine = engineFactories.stream().filter(s -> language.equalsIgnoreCase(s.getLanguageName())).findFirst().map(ScriptEngineFactory::getScriptEngine).orElse(null);
            if (scriptEngine == null) {
                Set availableLanguages = engineFactories.stream().map(ScriptEngineFactory::getLanguageName).collect(Collectors.toSet());
                throw new IllegalArgumentException("No ScriptEngineFactory found for language " + language + " (available languages: " + availableLanguages + ")");
            }
            return scriptEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evalScript(BundleContext bundleContext, ScriptEngine scriptEngine, String scriptToExecute, FormattingResultLog log, Map<String, Object> additionalBindings, boolean logScriptResult) throws ScriptException, IOException {
            SimpleBindings bindings = new SimpleBindings();
            ScriptHelperBinding scriptHelper = new ScriptHelperBinding(bundleContext);
            StringWriter stdout = new StringWriter();
            StringWriter stderr = new StringWriter();
            bindings.put("scriptHelper", (Object)scriptHelper);
            bindings.put("osgi", (Object)scriptHelper);
            bindings.put("log", (Object)log);
            bindings.put("bundleContext", (Object)bundleContext);
            if (additionalBindings != null) {
                for (Map.Entry<String, Object> additionalBinding : additionalBindings.entrySet()) {
                    bindings.put(additionalBinding.getKey(), additionalBinding.getValue());
                }
            }
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setBindings(bindings, 100);
            scriptContext.setWriter(stdout);
            scriptContext.setErrorWriter(stderr);
            try {
                log.debug(scriptToExecute, new Object[0]);
                Object scriptResult = scriptEngine.eval(scriptToExecute, (ScriptContext)scriptContext);
                this.appendStreamsToResult(log, stdout, stderr, scriptContext);
                if (scriptResult instanceof Result) {
                    Result result = (Result)scriptResult;
                    for (ResultLog.Entry entry : result) {
                        log.add(entry);
                    }
                } else if (scriptResult != null && logScriptResult) {
                    log.info("Script result: {}", new Object[]{scriptResult});
                }
                Object object = scriptResult;
                return object;
            }
            finally {
                scriptHelper.ungetServices();
            }
        }

        private void appendStreamsToResult(FormattingResultLog log, StringWriter stdout, StringWriter stderr, SimpleScriptContext scriptContext) throws IOException {
            scriptContext.getWriter().flush();
            String stdoutStr = stdout.toString();
            if (StringUtils.isNotBlank((CharSequence)stdoutStr)) {
                log.info("stdout of script: {}", new Object[]{stdoutStr});
            }
            scriptContext.getErrorWriter().flush();
            String stderrStr = stderr.toString();
            if (StringUtils.isNotBlank((CharSequence)stderrStr)) {
                log.critical("stderr of script: {}", new Object[]{stderrStr});
            }
        }

        class ScriptHelperBinding {
            private final BundleContext bundleContext;
            private List<ServiceReference<?>> references;
            private Map<String, Object> services;

            public ScriptHelperBinding(BundleContext bundleContext) {
                this.bundleContext = bundleContext;
            }

            public <T> T getService(Class<T> type) {
                ServiceReference ref;
                Object service;
                Object object = service = this.services == null ? null : this.services.get(type.getName());
                if (service == null && (ref = this.bundleContext.getServiceReference(type.getName())) != null && (service = this.bundleContext.getService(ref)) != null) {
                    if (this.services == null) {
                        this.services = new HashMap<String, Object>();
                    }
                    if (this.references == null) {
                        this.references = new ArrayList();
                    }
                    this.references.add(ref);
                    this.services.put(type.getName(), service);
                }
                return (T)service;
            }

            public <T> T[] getServices(Class<T> serviceType, String filter) throws InvalidSyntaxException {
                ServiceReference[] refs = this.bundleContext.getServiceReferences(serviceType.getName(), filter);
                Object[] result = null;
                if (refs != null) {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    for (int i = 0; i < refs.length; ++i) {
                        Object service = this.bundleContext.getService(refs[i]);
                        if (service == null) continue;
                        if (this.references == null) {
                            this.references = new ArrayList();
                        }
                        this.references.add(refs[i]);
                        objects.add(service);
                    }
                    if (!objects.isEmpty()) {
                        Object[] srv = (Object[])Array.newInstance(serviceType, objects.size());
                        result = objects.toArray(srv);
                    }
                }
                return result;
            }

            public void ungetServices() {
                if (this.references != null) {
                    for (ServiceReference<?> ref : this.references) {
                        this.bundleContext.ungetService(ref);
                    }
                    this.references.clear();
                }
                if (this.services != null) {
                    this.services.clear();
                }
            }
        }
    }

    @ObjectClassDefinition(name="Health Check: Sling Script (deprecated)", description="NOTE: This Sling pendant of org.apache.felix.hc.generalchecks.ScriptedHealthCheck allows to use scriptUrls with prefix 'jcr:' and has the additional bindings 'resourceResolver' and 'session'. Runs an arbitrary script in given scriping language (via javax.script). The script has the following default bindings available: 'log', 'scriptHelper', 'bundleContext', 'resourceResolver' and 'session'. 'log' is an instance of org.apache.felix.hc.api.FormattingResultLog and is used to define the result of the HC. 'scriptHelper.getService(classObj)' can be used as shortcut to retrieve a service.'scriptHelper.getServices(classObj, filter)' used to retrieve multiple services for a class using given filter. For all services retrieved via scriptHelper, unget() is called automatically at the end of the script execution.'bundleContext' is available for advanced use cases. The script does not need to return any value, but if it does and it is a org.apache.felix.hc.api.Result, that result and entries in 'log' are combined then).")
    static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check.")
        public String hc_name() default "Scripted Health Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Language", description="The language the script is written in. To use e.g. 'groovy', ensure osgi bundle 'groovy-jsr223' is available.")
        public String language() default "groovy";

        @AttributeDefinition(name="Script", description="The script itself (either use 'script' or 'scriptUrl').")
        public String script() default "log.info('ok'); log.warn('not so good'); log.critical('bad') // minimal example";

        @AttributeDefinition(name="Script Url", description="Url to the script to be used as alternative source (either use 'script' or 'scriptUrl').")
        public String scriptUrl() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Scripted HC (deprecated): {hc.name} (tags: {hc.tags}) {scriptUrl} language: {language}";
    }
}

