/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.utils.PublishUtils;
import com.google.common.collect.ImmutableMap;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfileImpl;
import io.wcm.handler.url.SiteConfig;
import io.wcm.handler.url.UrlMode;
import io.wcm.handler.url.UrlModes;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.featureflags.Features;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DynamicMediaSupportService.class}, immediate=true)
@Designate(ocd=Config.class)
public class DynamicMediaSupportServiceImpl
implements DynamicMediaSupportService {
    @Reference
    private Features featureFlagService;
    @Reference
    private PublishUtils dynamicMediaPublishUtils;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private boolean enabled;
    private boolean authorPreviewMode;
    private Dimension imageSizeLimit;
    private static final String SERVICEUSER_SUBSERVICE = "dynamic-media-support";
    private static final Logger log = LoggerFactory.getLogger(DynamicMediaSupportServiceImpl.class);

    @Activate
    private void activate(Config config) {
        this.enabled = config.enabled();
        this.authorPreviewMode = config.authorPreviewMode();
        this.imageSizeLimit = new Dimension(config.imageSizeLimitWidth(), config.imageSizeLimitHeight());
    }

    @Override
    public boolean isDynamicMediaEnabled() {
        return this.enabled && this.featureFlagService.isEnabled("com.adobe.dam.asset.scene7.feature.flag");
    }

    @Override
    @NotNull
    public Dimension getImageSizeLimit() {
        return this.imageSizeLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ImageProfile getImageProfile(@NotNull String profilePath) {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver((Map)ImmutableMap.of((Object)"sling.service.subservice", (Object)SERVICEUSER_SUBSERVICE));){
            Resource profileResource = resourceResolver.getResource(profilePath);
            if (profileResource == null) return null;
            ImageProfileImpl imageProfileImpl = new ImageProfileImpl(profileResource);
            return imageProfileImpl;
        }
        catch (LoginException ex) {
            log.error("Missing service user mapping for 'io.wcm.handler.media:dynamic-media-support' - see https://wcm.io/handler/media/configuration.html", (Throwable)ex);
        }
        return null;
    }

    @Override
    @Nullable
    public ImageProfile getImageProfileForAsset(@NotNull Asset asset) {
        HierarchyNodeInheritanceValueMap inheritanceValueMap;
        String imageProfilePath;
        Resource folderContentResource;
        Resource assetResource = (Resource)AdaptTo.notNull((Adaptable)asset, Resource.class);
        Resource folderResource = assetResource.getParent();
        if (folderResource != null && (folderContentResource = folderResource.getChild("jcr:content")) != null && (imageProfilePath = (String)(inheritanceValueMap = new HierarchyNodeInheritanceValueMap(folderContentResource)).getInherited("imageProfile", String.class)) != null) {
            return this.getImageProfile(imageProfilePath);
        }
        return null;
    }

    @Override
    @Nullable
    public String getDynamicMediaServerUrl(@NotNull Asset asset, @Nullable UrlMode urlMode) {
        Resource assetResource = (Resource)AdaptTo.notNull((Adaptable)asset, Resource.class);
        if (this.authorPreviewMode && !this.forcePublishMode(urlMode)) {
            SiteConfig siteConfig = (SiteConfig)AdaptTo.notNull((Adaptable)assetResource, SiteConfig.class);
            return StringUtils.defaultString((String)siteConfig.siteUrlAuthor());
        }
        try {
            String[] productionAssetUrls = this.dynamicMediaPublishUtils.externalizeImageDeliveryAsset(assetResource);
            if (productionAssetUrls != null && productionAssetUrls.length > 0) {
                return productionAssetUrls[0];
            }
        }
        catch (RepositoryException ex) {
            log.warn("Unable to get dynamic media production asset URLs for {}", (Object)assetResource.getPath(), (Object)ex);
        }
        return null;
    }

    private boolean forcePublishMode(@Nullable UrlMode urlMode) {
        return urlMode == UrlModes.FULL_URL_PUBLISH || urlMode == UrlModes.FULL_URL_PUBLISH_FORCENONSECURE || urlMode == UrlModes.FULL_URL_PUBLISH_FORCESECURE || urlMode == UrlModes.FULL_URL_PUBLISH_PROTOCOLRELATIVE;
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Dynamic Media Support", description="Configures dynamic media support in media handling.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable support for dynamic media. Only gets active when dynamic media is actually configured for the instance.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Author Preview Mode", description="Loads dynamic media images via author instance - to allow previewing unpublished images. Must not be enabled on publish instances.")
        public boolean authorPreviewMode() default false;

        @AttributeDefinition(name="Image width limit", description="The configured width value for 'Reply Image Size Limit'.")
        public long imageSizeLimitWidth() default 2000L;

        @AttributeDefinition(name="Image height limit", description="The configured height value for 'Reply Image Size Limit'.")
        public long imageSizeLimitHeight() default 2000L;
    }
}

