/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.engine.impl.filter;

import jakarta.servlet.Filter;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * Basic tests for the filter chain.
 */
public class SlingFilterChainHelperTest {

    private final Mockery context = new JUnit4Mockery();

    @Test
    public void testOrdering() {
        final SlingFilterChainHelper chain = new SlingFilterChainHelper();

        chain.addFilter(context.mock(Filter.class, "A"), null, 1L, 100, "1:100", null);
        chain.addFilter(context.mock(Filter.class, "B"), null, 2L, 100, "2:100", null);
        chain.addFilter(context.mock(Filter.class, "C"), null, 3L, -100, "3:-100", null);
        chain.addFilter(context.mock(Filter.class, "D"), null, 4L, -1000, "4:-1000", null);
        chain.addFilter(context.mock(Filter.class, "E"), null, 5L, 1000, "5:1000", null);

        final FilterHandle[] entries = chain.getFilters();
        assertEquals(5, entries.length);
        assertEquals("5:1000", entries[0].getOrderSource());
        assertEquals("1:100", entries[1].getOrderSource());
        assertEquals("2:100", entries[2].getOrderSource());
        assertEquals("3:-100", entries[3].getOrderSource());
        assertEquals("4:-1000", entries[4].getOrderSource());
    }
}
