/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class OsgiUtils {
    public static String escape(String value) {
        return value.replace("\\", "\\\\").replace("*", "\\*").replace("(", "\\(").replace(")", "\\)");
    }

    public static String osgiPropertyMapToString(Map<String, Object> map) {
        String result = "";
        if (map == null) {
            return result;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result = result + entry.getKey() + "=";
            if (entry.getValue() == null) {
                result = result + OsgiUtils.safeString(entry.getValue());
            } else if (entry.getValue().getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])entry.getValue()) {
                    result = result + OsgiUtils.safeString(obj) + ",";
                }
            } else {
                result = result + OsgiUtils.safeString(entry.getValue());
            }
            result = result + "\n";
        }
        return result;
    }

    private static String safeString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String getFilter(String configFactory, String propertyName, String propertyValue) {
        if (propertyName != null && propertyValue != null) {
            return "(&(service.factoryPid=" + OsgiUtils.escape(configFactory) + ")(" + OsgiUtils.escape(propertyName) + "=" + OsgiUtils.escape(propertyValue) + "))";
        }
        if (configFactory != null) {
            return "(service.factoryPid=" + OsgiUtils.escape(configFactory) + ")";
        }
        return null;
    }

    public static <K, V> Map<K, V> fromDictionary(Dictionary<K, V> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>(dictionary.size());
        Enumeration<K> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public static <K, V> Dictionary<K, V> toDictionary(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        Hashtable<K, V> dictionary = new Hashtable<K, V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ((Dictionary)dictionary).put(entry.getKey(), entry.getValue());
        }
        return dictionary;
    }

    public static Map<String, Object> sanitize(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map == null) {
            return result;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getKey().contains(":")) continue;
            Class<Object> valueClass = entry.getValue().getClass();
            String[] value = entry.getValue();
            if (valueClass.isArray() && (valueClass = valueClass.getComponentType()).equals(Object.class)) {
                Object[] array = value;
                value = Arrays.asList(array).toArray(new String[array.length]);
                valueClass = String.class;
            }
            if (!valueClass.isPrimitive() && !valueClass.equals(String.class) && !valueClass.equals(Boolean.class) && !valueClass.equals(Integer.class)) continue;
            result.put(entry.getKey(), value);
        }
        return result;
    }
}

