/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.extensions.sling;

import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.apache.sling.crankstart.api.CrankstartException;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class InstallerRegisterCommand
implements CrankstartCommand {
    public static final String CONTEXT_ATTRIBUTE_NAME = InstallerRegisterCommand.class.getName();
    public static final String I_INSTALLER_REGISTER = "sling.installer.register";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_INSTALLER_REGISTER.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "sling.installer.register: register prepared resources with the Sling installer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        List resources = (List)crankstartContext.getAttribute(CONTEXT_ATTRIBUTE_NAME);
        LinkedList<InstallableResource> toRegister = new LinkedList<InstallableResource>();
        for (String resourceRef : resources) {
            URL url = new URL(resourceRef);
            AutoCloseInputStream stream = new AutoCloseInputStream(url.openStream());
            String digest = resourceRef;
            toRegister.add(new InstallableResource(resourceRef, (InputStream)stream, null, digest, "file", Integer.valueOf(100)));
        }
        if (toRegister.isEmpty()) {
            this.log.warn("No prepared resources found to register, use {} first", (Object)I_INSTALLER_REGISTER);
        } else {
            String serviceClass;
            String prefix = commandLine.getQualifier();
            if (prefix == null || prefix.length() == 0) {
                throw new CrankstartException("Missing command qualifier, required to specify installer resources prefix");
            }
            BundleContext ctx = crankstartContext.getOsgiFramework().getBundleContext();
            ServiceReference ref = ctx.getServiceReference(serviceClass = OsgiInstaller.class.getName());
            if (ref == null) {
                throw new CrankstartException("Installer service not available, cannot register resource (" + serviceClass + ")");
            }
            OsgiInstaller installer = (OsgiInstaller)ctx.getService(ref);
            try {
                installer.registerResources(prefix, toRegister.toArray(new InstallableResource[0]));
                this.log.info("Registered {} resources with installer, using prefix '{}'", (Object)toRegister.size(), (Object)prefix);
                resources.clear();
            }
            finally {
                ctx.ungetService(ref);
            }
        }
    }
}

