/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class}, immediate=true)
public class UpdateUserGeneratedContentAction
implements FormAction {
    private static final Logger log = LoggerFactory.getLogger(UpdateUserGeneratedContentAction.class);
    private ResourceResolverFactory factory;

    @Activate
    public UpdateUserGeneratedContentAction(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        FormActionResult formActionResult;
        block9: {
            log.trace("handleForm");
            ValueMap properties = actionResource.getValueMap();
            ResourceResolver resolver = this.getResourceResolver();
            try {
                StringSubstitutor sub = new StringSubstitutor((Map)request.getFormData());
                String path = sub.replace((String)properties.get("path", String.class));
                log.debug("Updating UGC resource at path: {}", (Object)path);
                Resource resource = resolver.getResource(path);
                Resource ugcParent = this.findUgcParent(resource);
                if (!request.getOriginalRequest().getResourceResolver().getUserID().equals(ugcParent.getValueMap().get("user", String.class))) {
                    throw new FormException("Cannot modify content not created by the current user");
                }
                ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                ValueMap formData = request.getFormData();
                mvm.putAll((Map)formData);
                resolver.commit();
                log.debug("Successfully persisted resource");
                formActionResult = FormActionResult.success("Updated resource");
                if (resolver == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException | PersistenceException e) {
                    throw new FormException("Failed to update resource", e);
                }
            }
            resolver.close();
        }
        return formActionResult;
    }

    private Resource findUgcParent(Resource resource) throws FormException {
        if ("sling:UGC".equals(resource.getResourceType())) {
            return resource;
        }
        if (resource.getParent() != null) {
            return this.findUgcParent(resource.getParent());
        }
        throw new FormException("Failed to find UGC Parent");
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        return this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-ugc"));
    }

    @Override
    public boolean handles(Resource actionResource) {
        return "reference/components/forms/actions/updateugc".equals(actionResource.getResourceType());
    }
}

