/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class DeepNodeCreator {
    public Node deepCreateNode(String path, Session session, String nodeType) throws RepositoryException {
        Node result = null;
        if (session.itemExists(path)) {
            Item it = session.getItem(path);
            if (it.isNode()) {
                result = (Node)it;
            }
        } else {
            int slashPos = path.lastIndexOf("/");
            String parentPath = path.substring(0, slashPos);
            Node parent = null;
            parent = parentPath.length() == 0 ? session.getRootNode() : this.deepCreateNode(parentPath, session, nodeType);
            String childPath = path.substring(slashPos + 1);
            result = parent.addNode(childPath, this.getNodeType(parent, childPath, nodeType));
            this.nodeCreated(result);
            session.save();
        }
        return result;
    }

    protected String getNodeType(Node parent, String childPath, String suggestedNodeType) throws RepositoryException {
        return suggestedNodeType;
    }

    protected void nodeCreated(Node n) throws RepositoryException {
    }
}

