/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.text.StringTokenizer;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.MetricRuleConfig;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.config.ZabbixConfig;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZabbixMetrics.class);
    private final List<ZabbixConfig> originalConfigs;
    private List<InstanceGroup> allServices = new ArrayList<InstanceGroup>();

    public ZabbixMetrics(List<ZabbixConfig> originalConfigs, MeterSystem meterSystem) {
        this.originalConfigs = originalConfigs;
        this.initConfigs(meterSystem);
    }

    public Set<String> getAllMonitorMetricNames(String hostName) {
        return this.findInstanceGroup(hostName).map(InstanceGroup::getEnabledKeys).orElse(null);
    }

    public ConvertStatics convertMetrics(List<ZabbixRequest.AgentData> agentDataList) {
        if (CollectionUtils.isEmpty(agentDataList)) {
            return ConvertStatics.EMPTY;
        }
        return agentDataList.stream().collect(Collectors.groupingBy(ZabbixRequest.AgentData::getHost)).entrySet().stream().map(e -> this.findInstanceGroup((String)e.getKey()).map(instanceGroup -> instanceGroup.convertToMeter((List)e.getValue())).orElse(null)).filter(Objects::nonNull).reduce(ConvertStatics::merge).orElse(ConvertStatics.EMPTY);
    }

    private Optional<InstanceGroup> findInstanceGroup(String hostName) {
        return this.allServices.stream().filter(group -> group.matchesWithHostName(hostName)).findAny();
    }

    private void initConfigs(MeterSystem meterSystem) {
        HashMap tmpGroupCache = new HashMap();
        this.originalConfigs.forEach(c -> c.getEntities().getHostPatterns().forEach(instance -> tmpGroupCache.computeIfAbsent(instance, ins -> {
            InstanceGroup instanceGroup = new InstanceGroup((String)ins, meterSystem);
            this.allServices.add(instanceGroup);
            return instanceGroup;
        }).appendMetrics((ZabbixConfig)c)));
    }

    public static class ConvertStatics {
        public static final ConvertStatics EMPTY = ConvertStatics.builder().build();
        private int total;
        private int success;
        private int failed;
        private double useTime;

        public ConvertStatics merge(ConvertStatics statics) {
            this.total += statics.total;
            this.success += statics.success;
            this.failed += statics.failed;
            this.useTime += statics.useTime;
            return this;
        }

        @Generated
        ConvertStatics(int total, int success, int failed, double useTime) {
            this.total = total;
            this.success = success;
            this.failed = failed;
            this.useTime = useTime;
        }

        @Generated
        public static ConvertStaticsBuilder builder() {
            return new ConvertStaticsBuilder();
        }

        @Generated
        public int getTotal() {
            return this.total;
        }

        @Generated
        public int getSuccess() {
            return this.success;
        }

        @Generated
        public int getFailed() {
            return this.failed;
        }

        @Generated
        public double getUseTime() {
            return this.useTime;
        }

        @Generated
        public static class ConvertStaticsBuilder {
            @Generated
            private int total;
            @Generated
            private int success;
            @Generated
            private int failed;
            @Generated
            private double useTime;

            @Generated
            ConvertStaticsBuilder() {
            }

            @Generated
            public ConvertStaticsBuilder total(int total) {
                this.total = total;
                return this;
            }

            @Generated
            public ConvertStaticsBuilder success(int success) {
                this.success = success;
                return this;
            }

            @Generated
            public ConvertStaticsBuilder failed(int failed) {
                this.failed = failed;
                return this;
            }

            @Generated
            public ConvertStaticsBuilder useTime(double useTime) {
                this.useTime = useTime;
                return this;
            }

            @Generated
            public ConvertStatics build() {
                return new ConvertStatics(this.total, this.success, this.failed, this.useTime);
            }

            @Generated
            public String toString() {
                return "ZabbixMetrics.ConvertStatics.ConvertStaticsBuilder(total=" + this.total + ", success=" + this.success + ", failed=" + this.failed + ", useTime=" + this.useTime + ")";
            }
        }
    }

    private static class InstanceGroup {
        static final InstanceGroup EMPTY = new InstanceGroup("", null);
        private final Pattern instancePattern;
        private final MeterSystem meterSystem;
        private Set<String> enabledKeys;
        private List<MetricConvert> metricConverts;
        private List<ZabbixConfig.EntityLabel> labels;

        public InstanceGroup(String instancePattern, MeterSystem meterSystem) {
            this.instancePattern = Pattern.compile(instancePattern);
            this.meterSystem = meterSystem;
            this.enabledKeys = new HashSet<String>();
            this.metricConverts = new ArrayList<MetricConvert>();
            this.labels = new ArrayList<ZabbixConfig.EntityLabel>();
        }

        public void appendMetrics(ZabbixConfig config) {
            this.metricConverts.add(new MetricConvert((MetricRuleConfig)config, this.meterSystem));
            if (CollectionUtils.isNotEmpty(config.getEntities().getLabels())) {
                this.labels.addAll(config.getEntities().getLabels());
                config.getEntities().getLabels().stream().filter(l -> StringUtils.isNotBlank((CharSequence)l.getFromItem())).forEach(l -> this.enabledKeys.add(l.getFromItem()));
            }
            this.enabledKeys.addAll(config.getRequiredZabbixItemKeys());
        }

        public boolean matchesWithHostName(String hostName) {
            Matcher matcher = this.instancePattern.matcher(hostName);
            return matcher.matches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConvertStatics convertToMeter(List<ZabbixRequest.AgentData> dataList) {
            if (log.isDebugEnabled()) {
                log.debug("Receive zabbix agent data: {}", dataList);
            }
            StopWatch stopWatch = new StopWatch();
            ImmutableCollection sampleFamilies = null;
            try {
                stopWatch.start();
                Map<String, String> configLabels = this.parseConfigLabels(dataList);
                ImmutableMap families = (ImmutableMap)dataList.stream().filter(d -> d.getState() == 0 && NumberUtils.isParsable((String)d.getValue())).map(this::parseAgentData).map(b -> b.build(configLabels)).collect(Collectors.groupingBy(Sample::getName)).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> SampleFamilyBuilder.newBuilder((Sample[])((Sample[])((List)e.getValue()).stream().toArray(Sample[]::new))).build()));
                sampleFamilies = families.values();
                this.metricConverts.forEach(converter -> converter.toMeter(families));
            }
            finally {
                stopWatch.stop();
            }
            return ConvertStatics.builder().total(sampleFamilies.size()).success(sampleFamilies.size()).useTime((double)stopWatch.getTime() / 1000.0).build();
        }

        private Map<String, String> parseConfigLabels(List<ZabbixRequest.AgentData> dataList) {
            if (CollectionUtils.isEmpty(this.labels)) {
                return Collections.emptyMap();
            }
            return this.labels.stream().map(label -> {
                if (StringUtil.isNotBlank((String)label.getValue())) {
                    return Tuple.of((Object)label.getName(), (Object)label.getValue());
                }
                if (StringUtil.isNotBlank((String)label.getFromItem())) {
                    return dataList.stream().filter(d -> Objects.equals(d.getKey(), label.getFromItem())).findFirst().map(d -> Tuple.of((Object)label.getName(), (Object)d.getValue())).orElse(null);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        }

        private SampleBuilder parseAgentData(ZabbixRequest.AgentData data) {
            String keyName = data.getKey();
            SampleBuilder.SampleBuilderBuilder builder = SampleBuilder.builder();
            if (keyName.contains("[") && keyName.endsWith("]")) {
                String key = StringUtils.substringBefore((String)keyName, (String)"[");
                StringTokenizer tokenizer = new StringTokenizer(StringUtils.substringAfter((String)keyName.substring(0, keyName.length() - 1), (String)"["), ',', '\"');
                tokenizer.setIgnoreEmptyTokens(false);
                int inx = 1;
                ImmutableMap.Builder paramBuilder = ImmutableMap.builder();
                while (tokenizer.hasNext()) {
                    paramBuilder.put((Object)String.valueOf(inx++), (Object)tokenizer.next());
                }
                builder.name(key).labels((ImmutableMap<String, String>)paramBuilder.build());
            } else {
                builder.name(keyName).labels((ImmutableMap<String, String>)ImmutableMap.of());
            }
            return builder.hostName(data.getHost()).timestamp(TimeUnit.SECONDS.toMillis(data.getClock())).value(Double.parseDouble(data.getValue())).build();
        }

        @Generated
        public Set<String> getEnabledKeys() {
            return this.enabledKeys;
        }
    }

    private static class SampleBuilder {
        private final String name;
        private final String hostName;
        private final long timestamp;
        private final ImmutableMap<String, String> labels;
        private final double value;

        public Sample build(Map<String, String> configLabels) {
            return Sample.builder().name(this.escapedName(this.name)).labels(ImmutableMap.builder().putAll(this.labels).putAll(configLabels).put((Object)"host", (Object)this.hostName).build()).value(this.value).timestamp(this.timestamp).build();
        }

        private String escapedName(String name) {
            return name.replaceAll("\\.", "_");
        }

        @Generated
        SampleBuilder(String name, String hostName, long timestamp, ImmutableMap<String, String> labels, double value) {
            this.name = name;
            this.hostName = hostName;
            this.timestamp = timestamp;
            this.labels = labels;
            this.value = value;
        }

        @Generated
        public static SampleBuilderBuilder builder() {
            return new SampleBuilderBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getHostName() {
            return this.hostName;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public ImmutableMap<String, String> getLabels() {
            return this.labels;
        }

        @Generated
        public double getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SampleBuilder)) {
                return false;
            }
            SampleBuilder other = (SampleBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            if (Double.compare(this.getValue(), other.getValue()) != 0) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$hostName = this.getHostName();
            String other$hostName = other.getHostName();
            if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
                return false;
            }
            ImmutableMap<String, String> this$labels = this.getLabels();
            ImmutableMap<String, String> other$labels = other.getLabels();
            return !(this$labels == null ? other$labels != null : !this$labels.equals(other$labels));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SampleBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $hostName = this.getHostName();
            result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
            ImmutableMap<String, String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZabbixMetrics.SampleBuilder(name=" + this.getName() + ", hostName=" + this.getHostName() + ", timestamp=" + this.getTimestamp() + ", labels=" + String.valueOf(this.getLabels()) + ", value=" + this.getValue() + ")";
        }

        @Generated
        public static class SampleBuilderBuilder {
            @Generated
            private String name;
            @Generated
            private String hostName;
            @Generated
            private long timestamp;
            @Generated
            private ImmutableMap<String, String> labels;
            @Generated
            private double value;

            @Generated
            SampleBuilderBuilder() {
            }

            @Generated
            public SampleBuilderBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public SampleBuilderBuilder hostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            @Generated
            public SampleBuilderBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public SampleBuilderBuilder labels(ImmutableMap<String, String> labels) {
                this.labels = labels;
                return this;
            }

            @Generated
            public SampleBuilderBuilder value(double value) {
                this.value = value;
                return this;
            }

            @Generated
            public SampleBuilder build() {
                return new SampleBuilder(this.name, this.hostName, this.timestamp, this.labels, this.value);
            }

            @Generated
            public String toString() {
                return "ZabbixMetrics.SampleBuilder.SampleBuilderBuilder(name=" + this.name + ", hostName=" + this.hostName + ", timestamp=" + this.timestamp + ", labels=" + String.valueOf(this.labels) + ", value=" + this.value + ")";
            }
        }
    }
}

