/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.type;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.source.DetectPoint;

public class Call {
    private String source;
    private String target;
    private List<String> sourceComponents = new ArrayList<String>();
    private List<String> targetComponents = new ArrayList<String>();
    private String id;
    private List<DetectPoint> detectPoints = new ArrayList<DetectPoint>();

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void addSourceComponent(String component) {
        if (!this.sourceComponents.contains(component)) {
            this.sourceComponents.add(component);
        }
    }

    public void addTargetComponent(String component) {
        if (!this.targetComponents.contains(component)) {
            this.targetComponents.add(component);
        }
    }

    public void addDetectPoint(DetectPoint point) {
        if (!this.detectPoints.contains((Object)point)) {
            this.detectPoints.add(point);
        }
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public List<String> getSourceComponents() {
        return this.sourceComponents;
    }

    @Generated
    public List<String> getTargetComponents() {
        return this.targetComponents;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<DetectPoint> getDetectPoints() {
        return this.detectPoints;
    }

    @Generated
    public void setSourceComponents(List<String> sourceComponents) {
        this.sourceComponents = sourceComponents;
    }

    @Generated
    public void setTargetComponents(List<String> targetComponents) {
        this.targetComponents = targetComponents;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDetectPoints(List<DetectPoint> detectPoints) {
        this.detectPoints = detectPoints;
    }

    public static class CallDetail {
        private String id;
        private String source;
        private String target;
        private DetectPoint detectPoint;
        private Integer componentId;

        public void buildFromServiceRelation(String entityId, int componentId, DetectPoint detectPoint) {
            IDManager.ServiceID.ServiceRelationDefine serviceRelationDefine = IDManager.ServiceID.analysisRelationId(entityId);
            this.setId(entityId);
            this.setSource(serviceRelationDefine.getSourceId());
            this.setTarget(serviceRelationDefine.getDestId());
            this.setComponentId(componentId);
            this.setDetectPoint(detectPoint);
        }

        public void buildFromInstanceRelation(String entityId, DetectPoint detectPoint) {
            IDManager.ServiceInstanceID.ServiceInstanceRelationDefine serviceRelationDefine = IDManager.ServiceInstanceID.analysisRelationId(entityId);
            this.setId(entityId);
            this.setSource(serviceRelationDefine.getSourceId());
            this.setTarget(serviceRelationDefine.getDestId());
            this.setDetectPoint(detectPoint);
        }

        public void buildFromEndpointRelation(String entityId, DetectPoint detectPoint) {
            this.setId(entityId);
            IDManager.EndpointID.EndpointRelationDefine endpointRelationDefine = IDManager.EndpointID.analysisRelationId(entityId);
            IDManager.ServiceID.ServiceIDDefinition sourceService = IDManager.ServiceID.analysisId(endpointRelationDefine.getSourceServiceId());
            this.setDetectPoint(detectPoint);
            this.setSource(IDManager.EndpointID.buildId(endpointRelationDefine.getSourceServiceId(), endpointRelationDefine.getSource()));
            this.setTarget(IDManager.EndpointID.buildId(endpointRelationDefine.getDestServiceId(), endpointRelationDefine.getDest()));
            this.setComponentId(0);
        }

        public void buildProcessRelation(String entityId, int componentId, DetectPoint detectPoint) {
            this.setId(entityId);
            IDManager.ProcessID.ProcessRelationDefine processRelationDefine = IDManager.ProcessID.analysisRelationId(entityId);
            this.setDetectPoint(detectPoint);
            this.setSource(processRelationDefine.getSourceId());
            this.setTarget(processRelationDefine.getDestId());
            this.setComponentId(componentId);
        }

        @Generated
        private void setId(String id) {
            this.id = id;
        }

        @Generated
        private void setSource(String source) {
            this.source = source;
        }

        @Generated
        private void setTarget(String target) {
            this.target = target;
        }

        @Generated
        private void setDetectPoint(DetectPoint detectPoint) {
            this.detectPoint = detectPoint;
        }

        @Generated
        private void setComponentId(Integer componentId) {
            this.componentId = componentId;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getTarget() {
            return this.target;
        }

        @Generated
        public DetectPoint getDetectPoint() {
            return this.detectPoint;
        }

        @Generated
        public Integer getComponentId() {
            return this.componentId;
        }
    }
}

