/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.option.ParamAdder;
import com.orbitz.consul.option.QueryParameterOptions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueryParameterOptions", generator="Immutables")
@Immutable
public final class ImmutableQueryParameterOptions
extends QueryParameterOptions {
    private final ImmutableMap<String, Object> toQuery;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final Boolean replaceExistingChecks;
    @Nullable
    private final Boolean prune;

    private ImmutableQueryParameterOptions(ImmutableMap<String, Object> toQuery, ImmutableMap<String, String> toHeaders, @Nullable Boolean replaceExistingChecks, @Nullable Boolean prune) {
        this.toQuery = toQuery;
        this.toHeaders = toHeaders;
        this.replaceExistingChecks = replaceExistingChecks;
        this.prune = prune;
    }

    public ImmutableMap<String, Object> toQuery() {
        return this.toQuery;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<Boolean> getReplaceExistingChecks() {
        return Optional.ofNullable(this.replaceExistingChecks);
    }

    @Override
    public Optional<Boolean> getPrune() {
        return Optional.ofNullable(this.prune);
    }

    public final ImmutableQueryParameterOptions withToQuery(Map<String, ? extends Object> entries) {
        if (this.toQuery == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableQueryParameterOptions((ImmutableMap<String, Object>)newValue, this.toHeaders, this.replaceExistingChecks, this.prune);
    }

    public final ImmutableQueryParameterOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableQueryParameterOptions(this.toQuery, (ImmutableMap<String, String>)newValue, this.replaceExistingChecks, this.prune);
    }

    public final ImmutableQueryParameterOptions withReplaceExistingChecks(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.replaceExistingChecks, newValue)) {
            return this;
        }
        return new ImmutableQueryParameterOptions(this.toQuery, this.toHeaders, newValue, this.prune);
    }

    public final ImmutableQueryParameterOptions withReplaceExistingChecks(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.replaceExistingChecks, value)) {
            return this;
        }
        return new ImmutableQueryParameterOptions(this.toQuery, this.toHeaders, value, this.prune);
    }

    public final ImmutableQueryParameterOptions withPrune(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.prune, newValue)) {
            return this;
        }
        return new ImmutableQueryParameterOptions(this.toQuery, this.toHeaders, this.replaceExistingChecks, newValue);
    }

    public final ImmutableQueryParameterOptions withPrune(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.prune, value)) {
            return this;
        }
        return new ImmutableQueryParameterOptions(this.toQuery, this.toHeaders, this.replaceExistingChecks, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryParameterOptions && this.equalTo((ImmutableQueryParameterOptions)another);
    }

    private boolean equalTo(ImmutableQueryParameterOptions another) {
        return this.toQuery.equals(another.toQuery) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.replaceExistingChecks, another.replaceExistingChecks) && Objects.equals(this.prune, another.prune);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQuery.hashCode();
        h += (h << 5) + this.toHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.replaceExistingChecks);
        h += (h << 5) + Objects.hashCode(this.prune);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryParameterOptions").omitNullValues().add("toQuery", this.toQuery).add("toHeaders", this.toHeaders).add("replaceExistingChecks", (Object)this.replaceExistingChecks).add("prune", (Object)this.prune).toString();
    }

    public static ImmutableQueryParameterOptions copyOf(QueryParameterOptions instance) {
        if (instance instanceof ImmutableQueryParameterOptions) {
            return (ImmutableQueryParameterOptions)instance;
        }
        return ImmutableQueryParameterOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryParameterOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, Object> toQuery = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private Boolean replaceExistingChecks;
        @Nullable
        private Boolean prune;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryParameterOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ParamAdder instance;
            if (object instanceof QueryParameterOptions) {
                Optional<Boolean> replaceExistingChecksOptional;
                instance = (QueryParameterOptions)object;
                Optional<Boolean> pruneOptional = ((QueryParameterOptions)instance).getPrune();
                if (pruneOptional.isPresent()) {
                    this.prune(pruneOptional);
                }
                if ((replaceExistingChecksOptional = ((QueryParameterOptions)instance).getReplaceExistingChecks()).isPresent()) {
                    this.replaceExistingChecks(replaceExistingChecksOptional);
                }
            }
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.putAllToQuery(instance.toQuery());
                this.putAllToHeaders(instance.toHeaders());
            }
        }

        @CanIgnoreReturnValue
        public final Builder putToQuery(String key, Object value) {
            this.toQuery.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToQuery(Map.Entry<String, ? extends Object> entry) {
            this.toQuery.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQuery(Map<String, ? extends Object> entries) {
            this.toQuery = ImmutableMap.builder();
            return this.putAllToQuery(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToQuery(Map<String, ? extends Object> entries) {
            this.toQuery.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder replaceExistingChecks(boolean replaceExistingChecks) {
            this.replaceExistingChecks = replaceExistingChecks;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder replaceExistingChecks(Optional<Boolean> replaceExistingChecks) {
            this.replaceExistingChecks = replaceExistingChecks.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prune(boolean prune) {
            this.prune = prune;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prune(Optional<Boolean> prune) {
            this.prune = prune.orElse(null);
            return this;
        }

        public ImmutableQueryParameterOptions build() {
            return new ImmutableQueryParameterOptions(this.toQuery.build(), this.toHeaders.build(), this.replaceExistingChecks, this.prune);
        }
    }
}

