/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerEventType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBAsyncProfilerTaskQueryDAO
extends AbstractBanyanDBDAO
implements IAsyncProfilerTaskQueryDAO {
    private static final Gson GSON = new Gson();
    private static final Set<String> TAGS = ImmutableSet.of((Object)"service_id", (Object)"service_instance_ids", (Object)"task_id", (Object)"create_time", (Object)"duration", (Object)"events", (Object[])new String[]{"exec_args"});
    private final int queryMaxSize;

    public BanyanDBAsyncProfilerTaskQueryDAO(BanyanDBStorageClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public List<AsyncProfilerTask> getTaskList(final String serviceId, Long startTimeBucket, Long endTimeBucket, final Integer limit) throws IOException {
        long startTS = 0L;
        long endTS = UPPER_BOUND_TIME;
        if (startTimeBucket != null) {
            startTS = TimeBucket.getTimestamp((long)startTimeBucket);
        }
        if (endTimeBucket != null) {
            endTS = TimeBucket.getTimestamp((long)endTimeBucket);
        }
        StreamQueryResponse resp = this.query("async_profiler_task", TAGS, new TimestampRange(startTS, endTS), new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (limit != null) {
                    query.setLimit(limit.intValue());
                } else {
                    query.setLimit(BanyanDBAsyncProfilerTaskQueryDAO.this.queryMaxSize);
                }
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.DESC));
            }
        });
        ArrayList<AsyncProfilerTask> tasks = new ArrayList<AsyncProfilerTask>(resp.size());
        for (RowEntity entity : resp.getElements()) {
            tasks.add(this.buildAsyncProfilerTask(entity));
        }
        return tasks;
    }

    public AsyncProfilerTask getById(final String id) throws IOException {
        StreamQueryResponse resp = this.query("async_profiler_task", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)id)) {
                    query.and(this.eq("task_id", id));
                }
                query.setLimit(1);
            }
        });
        if (resp.size() == 0) {
            return null;
        }
        return this.buildAsyncProfilerTask((RowEntity)resp.getElements().get(0));
    }

    private AsyncProfilerTask buildAsyncProfilerTask(RowEntity data) {
        Type listType = new TypeToken<List<String>>(){}.getType();
        String events = (String)data.getTagValue("events");
        List eventList = (List)GSON.fromJson(events, listType);
        String serviceInstanceIds = (String)data.getTagValue("service_instance_ids");
        List serviceInstanceIdList = (List)GSON.fromJson(serviceInstanceIds, listType);
        return AsyncProfilerTask.builder().id((String)data.getTagValue("task_id")).serviceId((String)data.getTagValue("service_id")).serviceInstanceIds(serviceInstanceIdList).createTime(((Number)data.getTagValue("create_time")).longValue()).duration(((Number)data.getTagValue("duration")).intValue()).events(AsyncProfilerEventType.valueOfList((List)eventList)).execArgs((String)data.getTagValue("exec_args")).build();
    }
}

