/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.google.errorprone.annotations.CheckReturnValue;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.FunctionalDecoratingHttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceOptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.function.Function;

@FunctionalInterface
public interface HttpService
extends Service<HttpRequest, HttpResponse> {
    @Override
    @CheckReturnValue
    public HttpResponse serve(ServiceRequestContext var1, HttpRequest var2) throws Exception;

    default public <R extends Service<R_I, R_O>, R_I extends Request, R_O extends Response> R decorate(Function<? super HttpService, R> decorator) {
        Service newService = (Service)decorator.apply(this);
        if (newService == null) {
            throw new NullPointerException("decorator.apply() returned null: " + decorator);
        }
        return (R)newService;
    }

    default public HttpService decorate(DecoratingHttpServiceFunction function) {
        return new FunctionalDecoratingHttpService(this, function);
    }

    @UnstableApi
    default public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.BIDI_STREAMING;
    }

    @UnstableApi
    default public ServiceOptions options() {
        return ServiceOptions.of();
    }
}

