/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.PropertiesEndpointGroup;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class PropertiesEndpointGroupBuilder {
    @Nullable
    private final URL resourceUrl;
    @Nullable
    private final Properties properties;
    @Nullable
    private final Path path;
    private final String endpointKeyPrefix;
    private int defaultPort;
    private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();

    PropertiesEndpointGroupBuilder(ClassLoader classLoader, String resourceName, String endpointKeyPrefix) {
        URL resourceUrl = classLoader.getResource(resourceName);
        Preconditions.checkArgument(resourceUrl != null, "resource not found: %s", (Object)resourceName);
        this.resourceUrl = resourceUrl;
        this.endpointKeyPrefix = endpointKeyPrefix;
        this.properties = null;
        this.path = null;
    }

    PropertiesEndpointGroupBuilder(Properties properties, String endpointKeyPrefix) {
        this.properties = properties;
        this.endpointKeyPrefix = endpointKeyPrefix;
        this.resourceUrl = null;
        this.path = null;
    }

    PropertiesEndpointGroupBuilder(Path path, String endpointKeyPrefix) {
        this.path = path;
        this.endpointKeyPrefix = endpointKeyPrefix;
        this.resourceUrl = null;
        this.properties = null;
    }

    public PropertiesEndpointGroupBuilder defaultPort(int defaultPort) {
        Preconditions.checkArgument(defaultPort > 0 && defaultPort <= 65535, "defaultPort: %s (expected: 1-65535)", defaultPort);
        this.defaultPort = defaultPort;
        return this;
    }

    public PropertiesEndpointGroupBuilder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        return this;
    }

    public PropertiesEndpointGroup build() {
        if (this.resourceUrl != null) {
            return new PropertiesEndpointGroup(this.selectionStrategy, PropertiesEndpointGroupBuilder.loadEndpoints(this.resourceUrl, this.endpointKeyPrefix, this.defaultPort));
        }
        if (this.properties != null) {
            return new PropertiesEndpointGroup(this.selectionStrategy, PropertiesEndpointGroupBuilder.loadEndpoints(this.properties, this.endpointKeyPrefix, this.defaultPort));
        }
        assert (this.path != null);
        return new PropertiesEndpointGroup(this.selectionStrategy, this.path, this.endpointKeyPrefix, this.defaultPort);
    }

    private static List<Endpoint> loadEndpoints(URL resourceUrl, String endpointKeyPrefix, int defaultPort) {
        List<Endpoint> list;
        block8: {
            InputStream in = resourceUrl.openStream();
            try {
                Properties props = new Properties();
                props.load(in);
                list = PropertiesEndpointGroupBuilder.loadEndpoints(props, endpointKeyPrefix, defaultPort);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to load: " + resourceUrl.getFile(), e);
                }
            }
            in.close();
        }
        return list;
    }

    private static List<Endpoint> loadEndpoints(Properties properties, String endpointKeyPrefix, int defaultPort) {
        if (!endpointKeyPrefix.endsWith(".")) {
            endpointKeyPrefix = endpointKeyPrefix + ".";
        }
        ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith(endpointKeyPrefix)) continue;
            Endpoint endpoint = Endpoint.parse(value);
            newEndpoints.add(defaultPort == 0 ? endpoint : endpoint.withDefaultPort(defaultPort));
        }
        return ImmutableList.copyOf(newEndpoints);
    }
}

