/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.FragmentDefinition;
import graphql.language.InlineFragment;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class FragmentsOnCompositeType
extends AbstractRule {
    public FragmentsOnCompositeType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkInlineFragment(InlineFragment inlineFragment) {
        if (inlineFragment.getTypeCondition() == null) {
            return;
        }
        GraphQLType type = this.getValidationContext().getSchema().getType(inlineFragment.getTypeCondition().getName());
        if (type == null) {
            return;
        }
        if (!(type instanceof GraphQLCompositeType)) {
            String message = this.i18n(ValidationErrorType.InlineFragmentTypeConditionInvalid, "FragmentsOnCompositeType.invalidInlineTypeCondition", new Object[0]);
            this.addError(ValidationErrorType.InlineFragmentTypeConditionInvalid, inlineFragment.getSourceLocation(), message);
        }
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        GraphQLType type = this.getValidationContext().getSchema().getType(fragmentDefinition.getTypeCondition().getName());
        if (type == null) {
            return;
        }
        if (!(type instanceof GraphQLCompositeType)) {
            String message = this.i18n(ValidationErrorType.FragmentTypeConditionInvalid, "FragmentsOnCompositeType.invalidFragmentTypeCondition", new Object[0]);
            this.addError(ValidationErrorType.FragmentTypeConditionInvalid, fragmentDefinition.getSourceLocation(), message);
        }
    }
}

