/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.type;

import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class HashMapConverter {

    public static class ToStorage
    implements Convert2Storage<Map<String, Object>> {
        private Map<String, Object> source = new HashMap<String, Object>();

        @Override
        public void accept(String fieldName, Object fieldValue) {
            this.source.put(fieldName, fieldValue);
        }

        @Override
        public void accept(String fieldName, byte[] fieldValue) {
            if (CollectionUtils.isEmpty((byte[])fieldValue)) {
                this.source.put(fieldName, "");
            } else {
                this.source.put(fieldName, new String(Base64.getEncoder().encode(fieldValue)));
            }
        }

        @Override
        public void accept(String fieldName, List<String> fieldValue) {
            this.accept(fieldName, (Object)fieldValue);
        }

        @Override
        public Object get(String fieldName) {
            return this.source.get(fieldName);
        }

        @Override
        public Map<String, Object> obtain() {
            return this.source;
        }
    }

    public static class ToEntity
    implements Convert2Entity {
        private final Map<String, Object> source;

        @Override
        public Object get(String fieldName) {
            return this.source.get(fieldName);
        }

        @Override
        public byte[] getBytes(String fieldName) {
            String value = (String)this.source.get(fieldName);
            if (StringUtil.isEmpty((String)value)) {
                return new byte[0];
            }
            return Base64.getDecoder().decode(value);
        }

        @Generated
        public ToEntity(Map<String, Object> source) {
            this.source = source;
        }
    }
}

