/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.CiliumMetrics;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;

@ScopeDeclaration(id=79, name="CiliumServiceInstance", catalog="SERVICE_INSTANCE")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class CiliumServiceInstance
extends CiliumMetrics {
    private volatile String entityId;
    private String serviceId;
    private String serviceName;
    private String serviceInstanceName;
    public Layer layer;
    private DetectPoint detectPoint;

    @Override
    public int scope() {
        return 79;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.layer.isNormal());
        this.entityId = IDManager.ServiceInstanceID.buildId(this.serviceId, this.serviceInstanceName);
    }

    @Generated
    public CiliumServiceInstance() {
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CiliumServiceInstance)) {
            return false;
        }
        CiliumServiceInstance other = (CiliumServiceInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$serviceInstanceName = this.getServiceInstanceName();
        String other$serviceInstanceName = other.getServiceInstanceName();
        if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)((Object)this$layer)).equals((Object)other$layer)) {
            return false;
        }
        DetectPoint this$detectPoint = this.getDetectPoint();
        DetectPoint other$detectPoint = other.getDetectPoint();
        return !(this$detectPoint == null ? other$detectPoint != null : !((Object)((Object)this$detectPoint)).equals((Object)other$detectPoint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CiliumServiceInstance;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)((Object)$layer)).hashCode());
        DetectPoint $detectPoint = this.getDetectPoint();
        result = result * 59 + ($detectPoint == null ? 43 : ((Object)((Object)$detectPoint)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CiliumServiceInstance(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", layer=" + this.getLayer() + ", detectPoint=" + this.getDetectPoint() + ")";
    }
}

