/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.avg;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.BucketedValues;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MeterFunction(functionName="avgHistogram")
public abstract class AvgHistogramFunction
extends Meter
implements AcceptableValue<BucketedValues> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvgHistogramFunction.class);
    public static final String DATASET = "dataset";
    protected static final String SUMMATION = "datatable_summation";
    protected static final String COUNT = "datatable_count";
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="datatable_summation", storageOnly=true)
    @ElasticSearch.Column(legacyName="summation")
    @BanyanDB.MeasureField
    protected DataTable summation = new DataTable(30);
    @Column(name="datatable_count", storageOnly=true)
    @ElasticSearch.Column(legacyName="count")
    @BanyanDB.MeasureField
    protected DataTable count = new DataTable(30);
    @Column(name="dataset", dataType=Column.ValueDataType.HISTOGRAM, storageOnly=true, defaultValue=0)
    @BanyanDB.MeasureField
    private DataTable dataset = new DataTable(30);

    @Override
    public void accept(MeterEntity entity, BucketedValues value) {
        if (this.dataset.size() > 0 && !value.isCompatible(this.dataset)) {
            throw new IllegalArgumentException("Incompatible BucketedValues [" + value + "] for current HistogramFunction[" + this.dataset + "]");
        }
        this.entityId = entity.id();
        long[] values = value.getValues();
        for (int i = 0; i < values.length; ++i) {
            long bucket = value.getBuckets()[i];
            String bucketName = bucket == Long.MIN_VALUE ? "infinite-" : String.valueOf(bucket);
            this.summation.valueAccumulation(bucketName, values[i]);
            this.count.valueAccumulation(bucketName, 1L);
        }
    }

    @Override
    public boolean combine(Metrics metrics) {
        AvgHistogramFunction histogram = (AvgHistogramFunction)metrics;
        this.summation.append(histogram.summation);
        this.count.append(histogram.count);
        return true;
    }

    @Override
    public void calculate() {
        for (String key : this.summation.keys()) {
            long value = 0L;
            if (this.count.get(key) != 0L && (value = this.summation.get(key) / this.count.get(key)) == 0L && this.summation.get(key) > 0L) {
                value = 1L;
            }
            this.dataset.put(key, (Long)value);
        }
    }

    @Override
    public Metrics toHour() {
        AvgHistogramFunction metrics = (AvgHistogramFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        AvgHistogramFunction metrics = (AvgHistogramFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setCount(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setSummation(new DataTable(remoteData.getDataObjectStrings(1)));
        this.setDataset(new DataTable(remoteData.getDataObjectStrings(2)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataObjectStrings(this.count.toStorageData());
        remoteBuilder.addDataObjectStrings(this.summation.toStorageData());
        remoteBuilder.addDataObjectStrings(this.dataset.toStorageData());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public Class<? extends AvgHistogramFunctionBuilder> builder() {
        return AvgHistogramFunctionBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvgHistogramFunction)) {
            return false;
        }
        AvgHistogramFunction function = (AvgHistogramFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "AvgHistogramFunction(entityId=" + this.getEntityId() + ", summation=" + this.getSummation() + ", count=" + this.getCount() + ", dataset=" + this.getDataset() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public DataTable getCount() {
        return this.count;
    }

    @Generated
    public void setCount(DataTable count) {
        this.count = count;
    }

    @Generated
    public DataTable getDataset() {
        return this.dataset;
    }

    @Generated
    public void setDataset(DataTable dataset) {
        this.dataset = dataset;
    }

    public static class AvgHistogramFunctionBuilder
    implements StorageBuilder<AvgHistogramFunction> {
        @Override
        public AvgHistogramFunction storage2Entity(Convert2Entity converter) {
            AvgHistogramFunction metrics = new AvgHistogramFunction(){

                @Override
                public AcceptableValue<BucketedValues> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setDataset(new DataTable((String)converter.get(AvgHistogramFunction.DATASET)));
            metrics.setCount(new DataTable((String)converter.get(AvgHistogramFunction.COUNT)));
            metrics.setSummation(new DataTable((String)converter.get(AvgHistogramFunction.SUMMATION)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(AvgHistogramFunction storageData, Convert2Storage converter) {
            converter.accept(AvgHistogramFunction.DATASET, storageData.getDataset());
            converter.accept(AvgHistogramFunction.COUNT, storageData.getCount());
            converter.accept(AvgHistogramFunction.SUMMATION, storageData.getSummation());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

