/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;

public class TopNQueryResponse {
    private final List<TopNList> topNLists;

    TopNQueryResponse(BanyandbMeasure.TopNResponse response) {
        List<BanyandbMeasure.TopNList> timelines = response.getListsList();
        this.topNLists = new ArrayList<TopNList>(timelines.size());
        for (BanyandbMeasure.TopNList topNList : timelines) {
            this.topNLists.add(new TopNList(topNList.getTimestamp(), topNList.getItemsList()));
        }
    }

    public int size() {
        return this.topNLists == null ? 0 : this.topNLists.size();
    }

    public List<TopNList> getTopNLists() {
        return this.topNLists;
    }

    public static class Item {
        private final Map<String, TagAndValue<?>> tagValuesMap;
        private final Object value;

        static Item parseFrom(BanyandbMeasure.TopNList.Item item) {
            Object fieldValue = DataPoint.convertFileValueToJavaType(item.getValue());
            HashMap map = new HashMap(item.getEntityCount());
            for (BanyandbModel.Tag tag : item.getEntityList()) {
                map.put(tag.getKey(), TagAndValue.fromProtobuf(tag));
            }
            return new Item(map, fieldValue);
        }

        public Item(Map<String, TagAndValue<?>> tagValuesMap, Object value) {
            this.tagValuesMap = tagValuesMap;
            this.value = value;
        }

        public Map<String, TagAndValue<?>> getTagValuesMap() {
            return this.tagValuesMap;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class TopNList {
        private final long timestamp;
        private final List<Item> items;

        private TopNList(Timestamp ts, List<BanyandbMeasure.TopNList.Item> itemsList) {
            this.timestamp = ts.getSeconds() * 1000L + (long)(ts.getNanos() / 1000000);
            this.items = new ArrayList<Item>(itemsList.size());
            for (BanyandbMeasure.TopNList.Item item : itemsList) {
                this.items.add(Item.parseFrom(item));
            }
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<Item> getItems() {
            return this.items;
        }
    }
}

