/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.webapp;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import java.util.Collections;
import lombok.Generated;
import org.apache.skywalking.oap.server.webapp.Configuration;
import org.apache.skywalking.oap.server.webapp.OapProxyService;
import org.apache.skywalking.oap.server.webapp.ZipkinProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.env.EnvScalarConstructor;

public class ApplicationStartUp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationStartUp.class);

    public static void main(String[] args) throws Exception {
        Marker startedMarker = MarkerFactory.getMarker("Console");
        Yaml yaml = new Yaml(new EnvScalarConstructor(new TypeDescription(Configuration.class), Collections.emptyList(), new LoaderOptions()));
        yaml.addImplicitResolver(EnvScalarConstructor.ENV_TAG, EnvScalarConstructor.ENV_FORMAT, "$");
        Configuration configuration = yaml.loadAs(ApplicationStartUp.class.getResourceAsStream("/application.yml"), Configuration.class);
        int port = configuration.port();
        CharSequence[] oapServices = configuration.oapServices();
        HttpService indexPage = HttpFile.of(ApplicationStartUp.class.getClassLoader(), "/public/index.html").asService();
        HttpService zipkinIndexPage = HttpFile.of(ApplicationStartUp.class.getClassLoader(), "/zipkin-lens/index.html").asService();
        ZipkinProxyService zipkin = new ZipkinProxyService(configuration.zipkinServices());
        Server.builder().port(port, SessionProtocol.HTTP).service("/graphql", (HttpService)new OapProxyService((String[])oapServices)).service("/internal/l7check", (HttpService)HealthCheckService.of(new HealthChecker[0])).service("/zipkin/config.json", (HttpService)zipkin).serviceUnder("/zipkin/api", zipkin).serviceUnder("/zipkin", FileService.of(ApplicationStartUp.class.getClassLoader(), "/zipkin-lens").orElse(zipkinIndexPage)).serviceUnder("/", FileService.of(ApplicationStartUp.class.getClassLoader(), "/public").orElse(indexPage)).build().start().join();
        log.info(startedMarker, "SkyWalking Booster UI is now running. OAP service at {} and Booster UI at http://localhost:{}", (Object)String.join((CharSequence)", ", oapServices), (Object)port);
    }
}

