/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium.nodes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.cilium.api.peer.NotifyRequest;
import io.cilium.api.peer.PeerGrpc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.log4j.helpers.LogLog;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterWatcher;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumFetcherConfig;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.CiliumNode;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.CiliumNodeUpdateListener;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.ClientBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiliumNodeManager
implements ClusterWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CiliumNodeManager.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private final PeerGrpc.PeerBlockingStub peerStub;
    private final ClientBuilder clientBuilder;
    private final ModuleManager moduleManager;
    private final int retrySecond;
    private volatile List<RemoteInstance> remoteInstances;
    private List<CiliumNodeUpdateListener> listeners;
    private ClusterNodesQuery clusterNodesQuery;
    private volatile List<CiliumNode> allNodes;
    private volatile List<CiliumNode> usingNodes;

    public CiliumNodeManager(ModuleManager moduleManager, ClientBuilder clientBuilder, CiliumFetcherConfig config) {
        this.moduleManager = moduleManager;
        this.clientBuilder = clientBuilder;
        this.peerStub = this.clientBuilder.buildClient(config.getPeerHost(), config.getPeerPort(), PeerGrpc.PeerBlockingStub.class);
        this.allNodes = new ArrayList<CiliumNode>();
        this.usingNodes = new ArrayList<CiliumNode>();
        this.listeners = new ArrayList<CiliumNodeUpdateListener>();
        this.retrySecond = config.getFetchFailureRetrySecond();
    }

    public void start() {
        ClusterCoordinator coordinator = (ClusterCoordinator)this.moduleManager.find("cluster").provider().getService(ClusterCoordinator.class);
        coordinator.registerWatcher((ClusterWatcher)this);
        this.remoteInstances = ImmutableList.copyOf((Collection)coordinator.queryRemoteNodes());
        this.startWatchNodeUpdates();
        this.startRefreshRemoteNodes();
    }

    public void addListener(CiliumNodeUpdateListener listener) {
        this.listeners.add(listener);
    }

    private void listenNotified() {
        this.peerStub.notify(NotifyRequest.newBuilder().build()).forEachRemaining(changeNotification -> {
            log.debug("Receive cilium node change notification, name: {}, address: {}, type: {}", new Object[]{changeNotification.getName(), changeNotification.getAddress(), changeNotification.getType()});
            switch (changeNotification.getType()) {
                case PEER_ADDED: 
                case PEER_UPDATED: {
                    this.addOrUpdateNode(new CiliumNode(changeNotification.getAddress(), this.clientBuilder));
                    break;
                }
                case PEER_DELETED: {
                    this.removeNode(new CiliumNode(changeNotification.getAddress(), this.clientBuilder));
                    break;
                }
                default: {
                    log.error("Unknown cilium node change notification type: {}", changeNotification);
                }
            }
        });
    }

    private void startWatchNodeUpdates() {
        EXECUTOR.execute((Runnable)new RunnableWithExceptionProtection(this::listenNotified, t -> {
            LogLog.error((String)"Cilium node manager listen notified failure.", (Throwable)t);
            try {
                TimeUnit.SECONDS.sleep(this.retrySecond);
            }
            catch (InterruptedException e) {
                log.error("Failed to sleep for {} seconds.", (Object)this.retrySecond, (Object)e);
                return;
            }
            this.startWatchNodeUpdates();
        }));
    }

    private void startRefreshRemoteNodes() {
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::refreshRemoteNodes, t -> log.error("Scheduled refresh Remote Clients failure.", t)), 1L, 10L, TimeUnit.SECONDS);
    }

    private void refreshRemoteNodes() {
        if (Objects.isNull(this.clusterNodesQuery)) {
            this.clusterNodesQuery = (ClusterNodesQuery)this.moduleManager.find("cluster").provider().getService(ClusterNodesQuery.class);
        }
        this.onClusterNodesChanged(this.clusterNodesQuery.queryRemoteNodes());
    }

    private void addOrUpdateNode(CiliumNode node) {
        if (this.allNodes.contains(node)) {
            this.allNodes.remove(node);
        }
        this.allNodes.add(node);
        this.refreshUsingNodes();
    }

    private void removeNode(CiliumNode node) {
        this.allNodes.remove(node);
        this.refreshUsingNodes();
    }

    void refreshUsingNodes() {
        List<CiliumNode> shouldUsingNodes = this.buildShouldUsingNodes();
        log.debug("Trying to rebuilding using cilium nodes, current using nodes count: {}, new using nodes count: {}", (Object)this.usingNodes.size(), (Object)shouldUsingNodes.size());
        if (log.isDebugEnabled()) {
            shouldUsingNodes.forEach(node -> log.debug("Ready to using cilium node, wait notify: {}", (Object)node.getAddress()));
        }
        if (!this.compare(shouldUsingNodes)) {
            log.info("Rebuilding using cilium nodes, old using nodes count: {}, new using nodes count: {}", (Object)this.usingNodes.size(), (Object)shouldUsingNodes.size());
            this.reBuildUsingNodes(shouldUsingNodes);
        } else {
            log.debug("No need to rebuild using cilium nodes, old using nodes count: {}, new using nodes count: {}", (Object)this.usingNodes.size(), (Object)shouldUsingNodes.size());
        }
    }

    private void reBuildUsingNodes(List<CiliumNode> shouldUsingNodes) {
        Map<String, NodeWithAction> remoteClientCollection = this.usingNodes.stream().collect(Collectors.toMap(CiliumNode::getAddress, node -> new NodeWithAction((CiliumNode)node, Action.Close)));
        Map<String, NodeWithAction> latestRemoteClients = shouldUsingNodes.stream().collect(Collectors.toMap(CiliumNode::getAddress, remote -> new NodeWithAction((CiliumNode)remote, Action.Create)));
        Sets.SetView unChangeAddresses = Sets.intersection(remoteClientCollection.keySet(), latestRemoteClients.keySet());
        unChangeAddresses.stream().filter(remoteClientCollection::containsKey).forEach(unChangeAddress -> ((NodeWithAction)remoteClientCollection.get(unChangeAddress)).setAction(Action.Unchanged));
        unChangeAddresses.forEach(latestRemoteClients::remove);
        remoteClientCollection.putAll(latestRemoteClients);
        LinkedList<CiliumNode> newNodes = new LinkedList<CiliumNode>();
        remoteClientCollection.forEach((address, clientAction) -> {
            switch (clientAction.getAction()) {
                case Unchanged: {
                    newNodes.add(clientAction.getNode());
                    break;
                }
                case Create: {
                    newNodes.add(clientAction.getNode());
                    this.notifyListeners(clientAction.getNode(), Action.Create);
                    break;
                }
                case Close: {
                    this.notifyListeners(clientAction.getNode(), Action.Close);
                    clientAction.getNode().close();
                }
            }
        });
        newNodes.sort(Comparator.comparing(CiliumNode::getAddress));
        this.usingNodes = ImmutableList.copyOf(newNodes);
    }

    private void notifyListeners(CiliumNode node, Action action) {
        this.listeners.forEach(listener -> {
            if (action == Action.Create) {
                listener.onNodeAdded(node);
            } else if (action == Action.Close) {
                listener.onNodeDelete(node);
            }
        });
    }

    private void printUsingNodesList() {
        if (!log.isDebugEnabled()) {
            return;
        }
        String addresses = Joiner.on((String)", ").join((Iterable)this.usingNodes.stream().map(CiliumNode::getAddress).collect(Collectors.toList()));
        log.debug("Current using cilium nodes: {}", (Object)addresses);
    }

    private List<CiliumNode> buildShouldUsingNodes() {
        if (CollectionUtils.isEmpty(this.allNodes) || CollectionUtils.isEmpty(this.remoteInstances)) {
            log.debug("Found no cilium or backend nodes, skip all nodes, cilium nodes: {}, backend clients: {}", this.allNodes, this.remoteInstances);
            return ImmutableList.of();
        }
        this.allNodes.sort(Comparator.comparing(CiliumNode::getAddress));
        List totalBackendClients = this.remoteInstances.stream().sorted(Comparator.comparing(RemoteInstance::getAddress)).collect(Collectors.toList());
        int currentNodeIndex = totalBackendClients.indexOf(totalBackendClients.stream().filter(t -> t.getAddress().isSelf()).findFirst().get());
        if (totalBackendClients.size() > this.allNodes.size()) {
            if (currentNodeIndex >= this.allNodes.size()) {
                log.debug("Found no cilium nodes for current OAP node, skip all nodes, total cilium nodes: {}, total backend clients: {}, current node index: {}", new Object[]{this.allNodes.size(), totalBackendClients.size(), currentNodeIndex});
                return ImmutableList.of();
            }
            log.debug("Total cilium nodes: {}, total backend clients: {}, current node index: {}, using cilium node: {}", new Object[]{this.allNodes.size(), totalBackendClients.size(), currentNodeIndex, this.allNodes.get(currentNodeIndex)});
            return ImmutableList.of((Object)this.allNodes.get(currentNodeIndex));
        }
        int partNodesCount = this.allNodes.size() / totalBackendClients.size();
        if (partNodesCount == 0 && currentNodeIndex >= this.allNodes.size()) {
            log.debug("Found no cilium nodes for current OAP node, skip all nodes, total cilium nodes: {}, total backend clients: {}, current node index: {}", new Object[]{this.allNodes.size(), totalBackendClients.size(), currentNodeIndex});
            return ImmutableList.of();
        }
        int startIndex = currentNodeIndex * partNodesCount;
        int endIndex = currentNodeIndex == totalBackendClients.size() - 1 ? this.allNodes.size() : (currentNodeIndex + 1) * partNodesCount;
        log.debug("Total cilium nodes: {}, part nodes count: {}, current node index: {}, using nodes part: {} - {}", new Object[]{this.allNodes.size(), partNodesCount, currentNodeIndex, startIndex, endIndex});
        return ImmutableList.copyOf(this.allNodes.subList(startIndex, endIndex));
    }

    private boolean compare(List<CiliumNode> remoteInstances) {
        if (this.usingNodes.size() == remoteInstances.size()) {
            for (int i = 0; i < this.usingNodes.size(); ++i) {
                if (this.usingNodes.get(i).getAddress().equals(remoteInstances.get(i).getAddress())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void onClusterNodesChanged(List<RemoteInstance> remoteInstances) {
        this.remoteInstances = ImmutableList.copyOf(remoteInstances);
        this.refreshUsingNodes();
    }

    static enum Action {
        Close,
        Unchanged,
        Create;

    }

    private static class NodeWithAction {
        private final CiliumNode node;
        private Action action;

        @Generated
        public NodeWithAction(CiliumNode node, Action action) {
            this.node = node;
            this.action = action;
        }

        @Generated
        public CiliumNode getNode() {
            return this.node;
        }

        @Generated
        public Action getAction() {
            return this.action;
        }

        @Generated
        public void setAction(Action action) {
            this.action = action;
        }
    }
}

