/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.library.util.Address;
import org.apache.skywalking.oap.server.library.util.ConnectStringParseException;

public class ConnectUtils {
    private ConnectUtils() {
    }

    public static List<Address> parse(String connectString) throws ConnectStringParseException {
        String[] connects;
        connectString = connectString == null ? "" : connectString.trim();
        String string = connectString = connectString.startsWith(",") ? connectString.replace(",", "") : connectString;
        if (Strings.isNullOrEmpty((String)connectString)) {
            throw new ConnectStringParseException("ConnectString cannot be null or empty.");
        }
        ArrayList<Address> result = new ArrayList<Address>();
        for (String connect : connects = connectString.split(",")) {
            if (Strings.isNullOrEmpty((String)connect)) {
                throw new ConnectStringParseException("Invalid connect string pattern.");
            }
            String[] hostAndPort = connect.split(":");
            if (hostAndPort.length != 2) {
                throw new ConnectStringParseException("Invalid connect string pattern.");
            }
            Address address = new Address();
            address.setHost(hostAndPort[0]);
            try {
                address.setPort(Integer.parseInt(hostAndPort[1]));
            }
            catch (NumberFormatException e) {
                throw new ConnectStringParseException("Invalid connect string pattern.");
            }
            result.add(address);
        }
        return result;
    }
}

