/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ManagementCRUDEsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITemplateManagementEsDAO
extends ManagementCRUDEsDAO
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UITemplateManagementEsDAO.class);

    public UITemplateManagementEsDAO(ElasticSearchClient client, StorageBuilder storageBuilder) {
        super(client, (StorageBuilder<ManagementData>)storageBuilder);
    }

    public DashboardConfiguration getTemplate(String id) throws IOException {
        UITemplate uiTemplate = (UITemplate)super.getById("ui_template", id);
        if (uiTemplate != null) {
            return new DashboardConfiguration().fromEntity(uiTemplate);
        }
        return null;
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) {
        BoolQueryBuilder boolQuery = Query.bool();
        boolQuery.must((QueryBuilder)Query.term((String)"management_table", (Object)"ui_template"));
        if (!includingDisabled.booleanValue()) {
            boolQuery.must((QueryBuilder)Query.term((String)"disabled", (Object)BooleanUtils.booleanToValue((Boolean)includingDisabled)));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)boolQuery).size(Integer.valueOf(10000));
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ui_template");
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList<DashboardConfiguration> configs = new ArrayList<DashboardConfiguration>();
        UITemplate.Builder builder = new UITemplate.Builder();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSource();
            UITemplate uiTemplate = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ui_template", sourceAsMap));
            configs.add(new DashboardConfiguration().fromEntity(uiTemplate));
        }
        return configs;
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) throws IOException {
        UITemplate uiTemplate = setting.toEntity();
        if (super.create("ui_template", (ManagementData)uiTemplate)) {
            return TemplateChangeStatus.builder().status(true).id(uiTemplate.getTemplateId()).build();
        }
        return TemplateChangeStatus.builder().status(false).id(uiTemplate.getTemplateId()).message("Template already exists").build();
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) throws IOException {
        UITemplate uiTemplate = setting.toEntity();
        if (super.update("ui_template", (ManagementData)uiTemplate)) {
            return TemplateChangeStatus.builder().status(true).id(uiTemplate.getTemplateId()).build();
        }
        return TemplateChangeStatus.builder().status(false).id(uiTemplate.getTemplateId()).message("Can't find the template").build();
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        UITemplate uiTemplate = (UITemplate)super.getById("ui_template", id);
        if (uiTemplate != null) {
            uiTemplate.setDisabled(Integer.valueOf(1));
            super.update("ui_template", (ManagementData)uiTemplate);
            return TemplateChangeStatus.builder().status(true).id(id).build();
        }
        return TemplateChangeStatus.builder().status(false).id(id).message("Can't find the template").build();
    }
}

