/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;

public class SortValuesOp {
    public static ExpressionResult doSortValuesOp(ExpressionResult expResult, Optional<Integer> limit, int order) throws IllegalExpressionException {
        if (42 != order && 43 != order) {
            throw new IllegalExpressionException("Unsupported sort order.");
        }
        expResult.getResults().forEach(mqeValues -> {
            List values = mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).sorted(42 == order ? Comparator.comparingDouble(MQEValue::getDoubleValue) : Comparator.comparingDouble(MQEValue::getDoubleValue).reversed()).collect(Collectors.toList());
            if (limit.isPresent() && (Integer)limit.get() < values.size()) {
                mqeValues.setValues(values.subList(0, (Integer)limit.get()));
            } else {
                mqeValues.setValues(values);
            }
        });
        return expResult;
    }
}

