/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.utils.CollectionUtils;

public class BitList<E>
extends AbstractList<E>
implements Cloneable {
    private final BitSet rootSet;
    private volatile List<E> originList;
    private static final BitList emptyList = new BitList(Collections.emptyList());
    private volatile List<E> tailList = null;

    public BitList(List<E> originList) {
        this(originList, false);
    }

    public BitList(List<E> originList, boolean empty) {
        if (originList instanceof BitList) {
            this.originList = ((BitList)originList).getOriginList();
            this.tailList = ((BitList)originList).getTailList();
        } else {
            this.originList = originList;
        }
        this.rootSet = new BitSet();
        if (!empty) {
            this.rootSet.set(0, originList.size());
        } else {
            this.tailList = null;
        }
    }

    public BitList(List<E> originList, boolean empty, List<E> tailList) {
        this.originList = originList;
        this.rootSet = new BitSet();
        if (!empty) {
            this.rootSet.set(0, originList.size());
        }
        this.tailList = tailList;
    }

    public BitList(List<E> originList, BitSet rootSet, List<E> tailList) {
        this.originList = originList;
        this.rootSet = rootSet;
        this.tailList = tailList;
    }

    public synchronized List<E> getOriginList() {
        return this.originList;
    }

    public synchronized void addIndex(int index) {
        this.rootSet.set(index);
    }

    public synchronized int totalSetSize() {
        return this.originList.size();
    }

    public synchronized boolean indexExist(int index) {
        return this.rootSet.get(index);
    }

    public synchronized E getByIndex(int index) {
        return this.originList.get(index);
    }

    public synchronized BitList<E> and(BitList<E> target) {
        this.rootSet.and(target.rootSet);
        if (target.getTailList() != null) {
            target.getTailList().forEach(this::addToTailList);
        }
        return this;
    }

    public synchronized BitList<E> or(BitList<E> target) {
        BitSet resultSet = (BitSet)this.rootSet.clone();
        resultSet.or(target.rootSet);
        return new BitList<E>(this.originList, resultSet, this.tailList);
    }

    public synchronized boolean hasMoreElementInTailList() {
        return CollectionUtils.isNotEmpty(this.tailList);
    }

    public synchronized List<E> getTailList() {
        return this.tailList;
    }

    public synchronized void addToTailList(E e) {
        if (this.tailList == null) {
            this.tailList = new LinkedList();
        }
        this.tailList.add(e);
    }

    public synchronized E randomSelectOne() {
        int originSize = this.originList.size();
        int tailSize = this.tailList != null ? this.tailList.size() : 0;
        int totalSize = originSize + tailSize;
        int cardinality = this.rootSet.cardinality();
        int rate = originSize / cardinality;
        if (rate <= cardinality * 2) {
            int count = rate * 5;
            for (int i = 0; i < count; ++i) {
                int random = ThreadLocalRandom.current().nextInt(totalSize);
                if (random < originSize) {
                    if (!this.rootSet.get(random)) continue;
                    return this.originList.get(random);
                }
                return this.tailList.get(random - originSize);
            }
        }
        return this.get(ThreadLocalRandom.current().nextInt(cardinality + tailSize));
    }

    public static <T> BitList<T> emptyList() {
        return emptyList;
    }

    @Override
    public synchronized int size() {
        return this.rootSet.cardinality() + (CollectionUtils.isNotEmpty(this.tailList) ? this.tailList.size() : 0);
    }

    @Override
    public synchronized boolean contains(Object o) {
        int idx = this.originList.indexOf(o);
        return idx >= 0 && this.rootSet.get(idx) || CollectionUtils.isNotEmpty(this.tailList) && this.tailList.contains(o);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new BitListIterator(this, 0);
    }

    @Override
    public synchronized boolean add(E e) {
        int index = this.originList.indexOf(e);
        if (index > -1) {
            this.rootSet.set(index);
            return true;
        }
        if (this.tailList == null) {
            this.tailList = new LinkedList();
        }
        return this.tailList.add(e);
    }

    @Override
    public synchronized boolean remove(Object o) {
        int idx = this.originList.indexOf(o);
        if (idx > -1 && this.rootSet.get(idx)) {
            this.rootSet.set(idx, false);
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.tailList)) {
            return this.tailList.remove(o);
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.rootSet.clear();
        this.originList = Collections.emptyList();
        if (CollectionUtils.isNotEmpty(this.tailList)) {
            this.tailList = null;
        }
    }

    @Override
    public synchronized E get(int index) {
        int bitIndex = -1;
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.rootSet.cardinality()) {
            if (CollectionUtils.isNotEmpty(this.tailList)) {
                return this.tailList.get(index - this.rootSet.cardinality());
            }
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= index; ++i) {
            bitIndex = this.rootSet.nextSetBit(bitIndex + 1);
        }
        return this.originList.get(bitIndex);
    }

    @Override
    public synchronized E remove(int index) {
        int bitIndex = -1;
        if (index >= this.rootSet.cardinality()) {
            if (CollectionUtils.isNotEmpty(this.tailList)) {
                return this.tailList.remove(index - this.rootSet.cardinality());
            }
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= index; ++i) {
            bitIndex = this.rootSet.nextSetBit(bitIndex + 1);
        }
        this.rootSet.set(bitIndex, false);
        return this.originList.get(bitIndex);
    }

    @Override
    public synchronized int indexOf(Object o) {
        int bitIndex = -1;
        for (int i = 0; i < this.rootSet.cardinality(); ++i) {
            if (!this.originList.get(bitIndex = this.rootSet.nextSetBit(bitIndex + 1)).equals(o)) continue;
            return i;
        }
        if (CollectionUtils.isNotEmpty(this.tailList)) {
            int indexInTailList = this.tailList.indexOf(o);
            if (indexInTailList != -1) {
                return indexInTailList + this.rootSet.cardinality();
            }
            return -1;
        }
        return -1;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        if (c instanceof BitList) {
            this.rootSet.or(((BitList)c).rootSet);
            if (((BitList)c).hasMoreElementInTailList()) {
                for (E e : ((BitList)c).tailList) {
                    this.addToTailList(e);
                }
            }
            return true;
        }
        return super.addAll(c);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        int indexInTailList;
        int bitIndex = -1;
        int index = -1;
        if (CollectionUtils.isNotEmpty(this.tailList) && (indexInTailList = this.tailList.lastIndexOf(o)) > -1) {
            return indexInTailList + this.rootSet.cardinality();
        }
        for (int i = 0; i < this.rootSet.cardinality(); ++i) {
            if (!this.originList.get(bitIndex = this.rootSet.nextSetBit(bitIndex + 1)).equals(o)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.rootSet.isEmpty() && CollectionUtils.isEmpty(this.tailList);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new BitListIterator(this, 0);
    }

    @Override
    public synchronized ListIterator<E> listIterator(int index) {
        return new BitListIterator(this, index);
    }

    @Override
    public synchronized BitList<E> subList(int fromIndex, int toIndex) {
        LinkedList<E> copiedTailList;
        BitSet resultSet = (BitSet)this.rootSet.clone();
        LinkedList<E> linkedList = copiedTailList = this.tailList == null ? null : new LinkedList<E>(this.tailList);
        if (toIndex < this.size()) {
            if (toIndex < this.rootSet.cardinality()) {
                copiedTailList = null;
                resultSet.set(toIndex, resultSet.length(), false);
            } else {
                List list = copiedTailList = copiedTailList == null ? null : copiedTailList.subList(0, toIndex - this.rootSet.cardinality());
            }
        }
        if (fromIndex > 0) {
            if (fromIndex < this.rootSet.cardinality()) {
                resultSet.set(0, fromIndex, false);
            } else {
                resultSet.clear();
                copiedTailList = copiedTailList == null ? null : copiedTailList.subList(fromIndex - this.rootSet.cardinality(), copiedTailList.size());
            }
        }
        return new BitList<E>(this.originList, resultSet, copiedTailList);
    }

    public synchronized ArrayList<E> cloneToArrayList() {
        if (this.rootSet.cardinality() == this.originList.size() && CollectionUtils.isEmpty(this.tailList)) {
            return new ArrayList<E>(this.originList);
        }
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this);
        return arrayList;
    }

    public synchronized BitList<E> clone() {
        return new BitList<E>(this.originList, (BitSet)this.rootSet.clone(), this.tailList == null ? null : new LinkedList<E>(this.tailList));
    }

    public static class BitListIterator<E>
    implements ListIterator<E> {
        private BitList<E> bitList;
        private int index;
        private ListIterator<E> tailListIterator;
        private int curBitIndex = -1;
        private boolean isInTailList = false;
        private int lastReturnedIndex = -1;

        public BitListIterator(BitList<E> bitList, int index) {
            this.bitList = bitList;
            this.index = index - 1;
            for (int i = 0; i < index; ++i) {
                if (!this.isInTailList) {
                    this.curBitIndex = ((BitList)bitList).rootSet.nextSetBit(this.curBitIndex + 1);
                    if (this.curBitIndex != -1) continue;
                    if (!CollectionUtils.isNotEmpty(((BitList)bitList).tailList)) break;
                    this.isInTailList = true;
                    this.tailListIterator = ((BitList)bitList).tailList.listIterator();
                    this.tailListIterator.next();
                    continue;
                }
                this.tailListIterator.next();
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.isInTailList) {
                return this.tailListIterator.hasNext();
            }
            int nextBit = ((BitList)this.bitList).rootSet.nextSetBit(this.curBitIndex + 1);
            if (nextBit == -1) {
                return this.bitList.hasMoreElementInTailList();
            }
            return true;
        }

        @Override
        public synchronized E next() {
            if (this.isInTailList) {
                if (this.tailListIterator.hasNext()) {
                    ++this.index;
                    this.lastReturnedIndex = this.index;
                }
                return this.tailListIterator.next();
            }
            int nextBitIndex = ((BitList)this.bitList).rootSet.nextSetBit(this.curBitIndex + 1);
            if (nextBitIndex == -1) {
                if (this.bitList.hasMoreElementInTailList()) {
                    this.tailListIterator = ((BitList)this.bitList).tailList.listIterator();
                    this.isInTailList = true;
                    ++this.index;
                    this.lastReturnedIndex = this.index;
                    return this.tailListIterator.next();
                }
                throw new NoSuchElementException();
            }
            ++this.index;
            this.lastReturnedIndex = this.index;
            this.curBitIndex = nextBitIndex;
            return ((BitList)this.bitList).originList.get(nextBitIndex);
        }

        @Override
        public synchronized boolean hasPrevious() {
            if (this.isInTailList) {
                boolean hasPreviousInTailList = this.tailListIterator.hasPrevious();
                if (hasPreviousInTailList) {
                    return true;
                }
                return ((BitList)this.bitList).rootSet.previousSetBit(((BitList)this.bitList).rootSet.size()) != -1;
            }
            return this.curBitIndex != -1;
        }

        @Override
        public synchronized E previous() {
            if (this.isInTailList) {
                boolean hasPreviousInTailList = this.tailListIterator.hasPrevious();
                if (hasPreviousInTailList) {
                    this.lastReturnedIndex = this.index--;
                    return this.tailListIterator.previous();
                }
                int lastIndexInBit = ((BitList)this.bitList).rootSet.previousSetBit(((BitList)this.bitList).rootSet.size());
                if (lastIndexInBit == -1) {
                    throw new NoSuchElementException();
                }
                this.isInTailList = false;
                this.curBitIndex = ((BitList)this.bitList).rootSet.previousSetBit(lastIndexInBit - 1);
                this.lastReturnedIndex = this.index--;
                return ((BitList)this.bitList).originList.get(lastIndexInBit);
            }
            if (this.curBitIndex == -1) {
                throw new NoSuchElementException();
            }
            int nextBitIndex = this.curBitIndex;
            this.curBitIndex = ((BitList)this.bitList).rootSet.previousSetBit(this.curBitIndex - 1);
            this.lastReturnedIndex = this.index--;
            return ((BitList)this.bitList).originList.get(nextBitIndex);
        }

        @Override
        public synchronized int nextIndex() {
            return this.hasNext() ? this.index + 1 : this.index;
        }

        @Override
        public synchronized int previousIndex() {
            return this.index;
        }

        @Override
        public synchronized void remove() {
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this.lastReturnedIndex >= ((BitList)this.bitList).rootSet.cardinality()) {
                this.tailListIterator.remove();
            } else {
                int bitIndex = -1;
                for (int i = 0; i <= this.lastReturnedIndex; ++i) {
                    bitIndex = ((BitList)this.bitList).rootSet.nextSetBit(bitIndex + 1);
                }
                ((BitList)this.bitList).rootSet.set(bitIndex, false);
            }
            if (this.lastReturnedIndex <= this.index) {
                --this.index;
            }
        }

        @Override
        public synchronized void set(E e) {
            throw new UnsupportedOperationException("Set method is not supported in BitListIterator!");
        }

        @Override
        public synchronized void add(E e) {
            throw new UnsupportedOperationException("Add method is not supported in BitListIterator!");
        }
    }
}

