/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.file;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.file.TimedRollingFileAppender;
import java.io.File;
import java.io.IOException;

public final class LoadTestAwareAppender
implements TraceAppender {
    private TraceAppender nonLoadTestTraceAppender;
    private TraceAppender loadTestTraceAppender;

    private LoadTestAwareAppender(TraceAppender nonLoadTestTraceAppender, TraceAppender loadTestTraceAppender) {
        this.nonLoadTestTraceAppender = nonLoadTestTraceAppender;
        this.loadTestTraceAppender = loadTestTraceAppender;
    }

    public static LoadTestAwareAppender createLoadTestAwareTimedRollingFileAppender(String logName, boolean append) {
        TimedRollingFileAppender nonLoadTestTraceAppender = new TimedRollingFileAppender(logName, append);
        TimedRollingFileAppender loadTestTraceAppender = new TimedRollingFileAppender("shadow" + File.separator + logName, append);
        return new LoadTestAwareAppender(nonLoadTestTraceAppender, loadTestTraceAppender);
    }

    public static LoadTestAwareAppender createLoadTestAwareTimedRollingFileAppender(String logName, String rollingPolicy, String logReserveConfig) {
        TimedRollingFileAppender nonLoadTestTraceAppender = new TimedRollingFileAppender(logName, rollingPolicy, logReserveConfig);
        TimedRollingFileAppender loadTestTraceAppender = new TimedRollingFileAppender("shadow" + File.separator + logName, rollingPolicy, logReserveConfig);
        return new LoadTestAwareAppender(nonLoadTestTraceAppender, loadTestTraceAppender);
    }

    public void append(String log, boolean loadTest) throws IOException {
        if (loadTest) {
            this.loadTestTraceAppender.append(log);
        } else {
            this.nonLoadTestTraceAppender.append(log);
        }
    }

    @Override
    public void flush() throws IOException {
        this.nonLoadTestTraceAppender.flush();
        this.loadTestTraceAppender.flush();
    }

    @Override
    public void append(String log) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() {
        this.nonLoadTestTraceAppender.cleanup();
        this.loadTestTraceAppender.cleanup();
    }
}

