/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.neo4j;

import java.util.Map;
import org.neo4j.driver.Driver;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.neo4j.Neo4jHealthIndicator;
import org.springframework.boot.actuate.neo4j.Neo4jReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

class Neo4jHealthContributorConfigurations {
    Neo4jHealthContributorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Flux.class})
    static class Neo4jReactiveConfiguration
    extends CompositeReactiveHealthContributorConfiguration<Neo4jReactiveHealthIndicator, Driver> {
        Neo4jReactiveConfiguration() {
            super(Neo4jReactiveHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthIndicator", "neo4jHealthContributor"})
        ReactiveHealthContributor neo4jHealthContributor(Map<String, Driver> drivers) {
            return (ReactiveHealthContributor)this.createContributor(drivers);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Neo4jConfiguration
    extends CompositeHealthContributorConfiguration<Neo4jHealthIndicator, Driver> {
        Neo4jConfiguration() {
            super(Neo4jHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"neo4jHealthIndicator", "neo4jHealthContributor"})
        HealthContributor neo4jHealthContributor(Map<String, Driver> drivers) {
            return (HealthContributor)this.createContributor(drivers);
        }
    }
}

