/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.utils;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.transport.SofaStreamObserver;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import triple.Request;

public class SofaProtoUtils {
    public static boolean isProtoClass(Object object) {
        return object instanceof BindableService;
    }

    public static Set<String> getMethodNames(String interfaceId) {
        Method[] methods;
        HashSet<String> result = new HashSet<String>();
        Class interfaceClass = ClassUtils.forName(interfaceId);
        for (Method method : methods = interfaceClass.getMethods()) {
            result.add(method.getName());
        }
        return result;
    }

    public static boolean checkIfUseGeneric(ConsumerConfig consumerConfig) {
        Class<?> proxyClass = consumerConfig.getProxyClass();
        Class<?> enclosingClass = proxyClass.getEnclosingClass();
        if (enclosingClass != null) {
            try {
                enclosingClass.getDeclaredMethod("getSofaStub", Channel.class, CallOptions.class, Integer.TYPE);
                return false;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
        return true;
    }

    public static MethodDescriptor.MethodType mapGrpcCallType(String callType) {
        return Optional.ofNullable(callType).map(type -> {
            switch (type) {
                case "bidirectionalStream": {
                    return MethodDescriptor.MethodType.BIDI_STREAMING;
                }
                case "clientStream": {
                    return MethodDescriptor.MethodType.CLIENT_STREAMING;
                }
                case "serverStream": {
                    return MethodDescriptor.MethodType.SERVER_STREAMING;
                }
            }
            throw new SofaRpcException(260, "Unsupported invoke type:" + callType);
        }).orElse(MethodDescriptor.MethodType.UNARY);
    }

    public static Map<String, String> cacheStreamCallType(Class proxyClass) {
        Method[] declaredMethods;
        ConcurrentHashMap<String, String> methodCallType = new ConcurrentHashMap<String, String>();
        for (Method method : declaredMethods = proxyClass.getDeclaredMethods()) {
            String streamType = SofaProtoUtils.mapStreamType(method);
            if (!StringUtils.isNotBlank(streamType)) continue;
            methodCallType.put(method.getName(), streamType);
        }
        return methodCallType;
    }

    private static String mapStreamType(Method method) {
        block7: {
            block6: {
                Class<?>[] paramClasses = method.getParameterTypes();
                Class<?> returnClass = method.getReturnType();
                int paramLen = paramClasses.length;
                if (paramLen > 0 && SofaStreamObserver.class.isAssignableFrom(paramClasses[0]) && SofaStreamObserver.class.isAssignableFrom(returnClass)) {
                    if (paramLen > 1) {
                        throw new SofaRpcException(260, "Bidirectional/Client stream method parameters can be only one StreamHandler.");
                    }
                    return "bidirectionalStream";
                }
                if (paramLen > 1 && SofaStreamObserver.class.isAssignableFrom(paramClasses[paramLen - 1]) && Void.TYPE == returnClass) {
                    return "serverStream";
                }
                if (SofaStreamObserver.class.isAssignableFrom(returnClass)) break block6;
                if (!Arrays.stream(paramClasses).anyMatch(SofaStreamObserver.class::isAssignableFrom)) break block7;
            }
            throw new SofaRpcException(260, "SofaStreamObserver can only at the specified location of parameter.Please check related docs.");
        }
        return null;
    }

    public static Request buildRequest(String[] methodArgSigs, Object[] methodArgs, String serialization, Serializer serializer, int backOffset) {
        Request.Builder builder = Request.newBuilder();
        builder.setSerializeType(serialization);
        for (int i = 0; i < methodArgSigs.length - backOffset; ++i) {
            Object arg = methodArgs[i];
            ByteString argByteString = ByteString.copyFrom((byte[])serializer.encode(arg, null).array());
            builder.addArgs(argByteString);
            builder.addArgTypes(methodArgSigs[i]);
        }
        return builder.build();
    }
}

