/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter.authc;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.web.filter.authc.HttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpAuthenticationFilter
extends HttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicHttpAuthenticationFilter.class);

    public BasicHttpAuthenticationFilter() {
        this.setAuthcScheme("BASIC");
        this.setAuthzScheme("BASIC");
    }

    @Override
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String authorizationHeader = this.getAuthzHeader(request);
        if (authorizationHeader == null || authorizationHeader.length() == 0) {
            return this.createToken("", "", request, response);
        }
        log.debug("Attempting to execute login with auth header");
        String[] prinCred = this.getPrincipalsAndCredentials(authorizationHeader, request);
        if (prinCred == null || prinCred.length < 2) {
            String username = prinCred == null || prinCred.length == 0 ? "" : prinCred[0];
            return this.createToken(username, "", request, response);
        }
        String username = prinCred[0];
        String password = prinCred[1];
        return this.createToken(username, password, request, response);
    }

    @Override
    protected String[] getPrincipalsAndCredentials(String scheme, String encoded) {
        String decoded = Base64.decodeToString((String)encoded);
        return decoded.split(":", 2);
    }
}

