/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.thymeleaf.spring4.templateresolver.SpringResourceTemplateResolver;

abstract class AbstractTemplateResolverConfiguration {
    private static final Log logger = LogFactory.getLog(AbstractTemplateResolverConfiguration.class);
    private final ThymeleafProperties properties;
    private final ApplicationContext applicationContext;

    AbstractTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    protected final ThymeleafProperties getProperties() {
        return this.properties;
    }

    @PostConstruct
    public void checkTemplateLocationExists() {
        TemplateLocation location;
        boolean checkTemplateLocation = this.properties.isCheckTemplateLocation();
        if (checkTemplateLocation && !(location = new TemplateLocation(this.properties.getPrefix())).exists((ResourcePatternResolver)this.applicationContext)) {
            logger.warn((Object)("Cannot find template location: " + location + " (please add some templates or check your Thymeleaf configuration)"));
        }
    }

    @Bean
    public SpringResourceTemplateResolver defaultTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.properties.getPrefix());
        resolver.setSuffix(this.properties.getSuffix());
        resolver.setTemplateMode(this.properties.getMode());
        if (this.properties.getEncoding() != null) {
            resolver.setCharacterEncoding(this.properties.getEncoding().name());
        }
        resolver.setCacheable(this.properties.isCache());
        Integer order = this.properties.getTemplateResolverOrder();
        if (order != null) {
            resolver.setOrder(order);
        }
        return resolver;
    }
}

