/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.sla;

import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.sla.ResAllocs;
import com.netflix.fenzo.sla.ResAllocsBuilder;
import java.util.Map;

public final class ResAllocsUtil {
    public static ResAllocs add(ResAllocs first, ResAllocs second) {
        return new ResAllocsBuilder(first.getTaskGroupName()).withCores(first.getCores() + second.getCores()).withMemory(first.getMemory() + second.getMemory()).withNetworkMbps(first.getNetworkMbps() + second.getNetworkMbps()).withDisk(first.getDisk() + second.getDisk()).build();
    }

    public static ResAllocs add(ResAllocs first, QueuableTask second) {
        return new ResAllocsBuilder(first.getTaskGroupName()).withCores(first.getCores() + second.getCPUs()).withMemory(first.getMemory() + second.getMemory()).withNetworkMbps(first.getNetworkMbps() + second.getNetworkMbps()).withDisk(first.getDisk() + second.getDisk()).build();
    }

    public static ResAllocs subtract(ResAllocs first, ResAllocs second) {
        return new ResAllocsBuilder(first.getTaskGroupName()).withCores(first.getCores() - second.getCores()).withMemory(first.getMemory() - second.getMemory()).withNetworkMbps(first.getNetworkMbps() - second.getNetworkMbps()).withDisk(first.getDisk() - second.getDisk()).build();
    }

    public static ResAllocs ceilingOf(ResAllocs first, ResAllocs second) {
        return new ResAllocsBuilder(first.getTaskGroupName()).withCores(Math.max(first.getCores(), second.getCores())).withMemory(Math.max(first.getMemory(), second.getMemory())).withNetworkMbps(Math.max(first.getNetworkMbps(), second.getNetworkMbps())).withDisk(Math.max(first.getDisk(), second.getDisk())).build();
    }

    public static boolean isBounded(QueuableTask first, ResAllocs second) {
        if (first.getCPUs() > second.getCores()) {
            return false;
        }
        if (first.getMemory() > second.getMemory()) {
            return false;
        }
        if (first.getNetworkMbps() > second.getNetworkMbps()) {
            return false;
        }
        return !(first.getDisk() > second.getDisk());
    }

    public static boolean isBounded(ResAllocs first, QueuableTask second) {
        if (first.getCores() > second.getCPUs()) {
            return false;
        }
        if (first.getMemory() > second.getMemory()) {
            return false;
        }
        if (first.getNetworkMbps() > second.getNetworkMbps()) {
            return false;
        }
        return !(first.getDisk() > second.getDisk());
    }

    public static boolean isBounded(ResAllocs first, ResAllocs second) {
        if (first.getCores() > second.getCores()) {
            return false;
        }
        if (first.getMemory() > second.getMemory()) {
            return false;
        }
        if (first.getNetworkMbps() > second.getNetworkMbps()) {
            return false;
        }
        return !(first.getDisk() > second.getDisk());
    }

    public static boolean hasEqualResources(ResAllocs first, ResAllocs second) {
        return first.getCores() == second.getCores() && first.getMemory() == second.getMemory() && first.getNetworkMbps() == second.getNetworkMbps() && first.getDisk() == second.getDisk();
    }

    public static ResAllocs empty() {
        return ResAllocsUtil.emptyOf("anonymous");
    }

    public static ResAllocs emptyOf(String name) {
        return new ResAllocsBuilder(name).withCores(0.0).withMemory(0.0).withNetworkMbps(0.0).withDisk(0.0).build();
    }

    public static ResAllocs rename(String newName, ResAllocs allocs) {
        return new ResAllocsBuilder(newName).withCores(allocs.getCores()).withMemory(allocs.getMemory()).withNetworkMbps(allocs.getNetworkMbps()).withDisk(allocs.getDisk()).build();
    }

    public static ResAllocs toResAllocs(String name, Map<VMResource, Double> resourceMap) {
        return new ResAllocsBuilder(name).withCores(resourceMap.getOrDefault((Object)VMResource.CPU, 0.0)).withMemory(resourceMap.getOrDefault((Object)VMResource.Memory, 0.0)).withNetworkMbps(resourceMap.getOrDefault((Object)VMResource.Network, 0.0)).withDisk(resourceMap.getOrDefault((Object)VMResource.Disk, 0.0)).build();
    }
}

