/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.queues.tiered.QueueBucket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortedBuckets {
    private static final Logger logger = LoggerFactory.getLogger(SortedBuckets.class);
    private final List<QueueBucket> buckets = new ArrayList<QueueBucket>();
    private final Map<String, QueueBucket> bucketMap = new HashMap<String, QueueBucket>();
    private final Comparator<QueueBucket> comparator = new Comparator<QueueBucket>(){

        @Override
        public int compare(QueueBucket o1, QueueBucket o2) {
            return Double.compare(o1.getDominantUsageShare(), o2.getDominantUsageShare());
        }
    };
    private final UsageTrackedQueue.ResUsage parentUsage;

    SortedBuckets(UsageTrackedQueue.ResUsage parentUsage) {
        this.parentUsage = parentUsage;
    }

    boolean add(QueueBucket bucket) {
        if (this.bucketMap.containsKey(bucket.getName())) {
            return false;
        }
        if (this.buckets.isEmpty()) {
            this.buckets.add(bucket);
        } else {
            this.buckets.add(this.findInsertionPoint(bucket, this.buckets), bucket);
        }
        this.bucketMap.put(bucket.getName(), bucket);
        return true;
    }

    QueueBucket remove(String bucketName) {
        int remPos;
        QueueBucket bucket = this.bucketMap.get(bucketName);
        if (bucket == null) {
            return null;
        }
        int index = this.findInsertionPoint(bucket, this.buckets);
        if (index < 0) {
            throw new IllegalStateException("Unexpected: bucket with name=" + bucketName + " does not exist");
        }
        int n = remPos = this.buckets.get(index).getName().equals(bucketName) ? index : -1;
        if (remPos < 0) {
            remPos = this.findWalkingLeft(this.buckets, index, bucketName, bucket.getDominantUsageShare());
        }
        if (remPos < 0) {
            remPos = this.findWalkingRight(this.buckets, index, bucketName, bucket.getDominantUsageShare());
        }
        if (remPos < 0) {
            logger.error("Unexpected: bucket with name=" + bucketName + " not found to remove, traversing " + this.buckets.size() + " buckets to remove it");
            logger.warn("Invalid sorted buckets list: " + this.getBucketsListString());
            this.removeBucketAndResort(bucketName);
        } else {
            this.buckets.remove(remPos);
        }
        this.bucketMap.remove(bucketName);
        return bucket;
    }

    private void removeBucketAndResort(String bucketName) {
        HashSet<String> names = new HashSet<String>();
        if (!this.buckets.isEmpty()) {
            Iterator<QueueBucket> iterator = this.buckets.iterator();
            QueueBucket prev = null;
            boolean isSorted = true;
            while (iterator.hasNext()) {
                QueueBucket b = iterator.next();
                if (!names.add(b.getName())) {
                    logger.error("Bucket " + b.getName() + " already existed in the list, removing");
                    isSorted = false;
                    iterator.remove();
                    continue;
                }
                if (b.getName().equals(bucketName)) {
                    iterator.remove();
                    continue;
                }
                if (prev != null) {
                    int compare = this.comparator.compare(prev, b);
                    isSorted = isSorted && compare <= 0;
                }
                prev = b;
            }
            logger.warn("Re-sorting buckets list");
            this.resort();
        }
    }

    private String getBucketsListString() {
        StringBuilder builder = new StringBuilder("[");
        for (QueueBucket b : this.buckets) {
            builder.append(b.getName()).append(":").append(b.getDominantUsageShare()).append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    QueueBucket get(String bucketName) {
        return this.bucketMap.get(bucketName);
    }

    private int findWalkingRight(List<QueueBucket> buckets, int index, String bucketName, double dominantUsageShare) {
        int pos = index;
        while (++pos < buckets.size() && buckets.get(pos).getDominantUsageShare() == dominantUsageShare) {
            if (!buckets.get(pos).getName().equals(bucketName)) continue;
            return pos;
        }
        return -1;
    }

    private int findWalkingLeft(List<QueueBucket> buckets, int index, String bucketName, double dominantUsageShare) {
        int pos = index;
        while (--pos >= 0 && buckets.get(pos).getDominantUsageShare() == dominantUsageShare) {
            if (!buckets.get(pos).getName().equals(bucketName)) continue;
            return pos;
        }
        return -1;
    }

    private int findInsertionPoint(QueueBucket bucket, List<QueueBucket> buckets) {
        int i = Collections.binarySearch(buckets, bucket, this.comparator);
        if (i >= 0) {
            return i;
        }
        return -i - 1;
    }

    List<QueueBucket> getSortedList() {
        return Collections.unmodifiableList(this.buckets);
    }

    void resort() {
        ArrayList<QueueBucket> old = new ArrayList<QueueBucket>(this.buckets);
        this.bucketMap.clear();
        this.buckets.clear();
        for (QueueBucket b : old) {
            this.add(b);
        }
    }
}

