/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.PacketCodec;
import org.apache.shardingsphere.db.protocol.netty.ChannelAttrInitializer;
import org.apache.shardingsphere.db.protocol.netty.ProxyFlowControlHandler;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelInboundHandler;
import org.apache.shardingsphere.proxy.frontend.netty.FrontendChannelLimitationInboundHandler;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class ServerHandlerInitializer
extends ChannelInitializer<Channel> {
    private final DatabaseType databaseType;

    protected void initChannel(Channel socketChannel) {
        DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine = (DatabaseProtocolFrontendEngine)DatabaseTypedSPILoader.getService(DatabaseProtocolFrontendEngine.class, (DatabaseType)this.databaseType);
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelAttrInitializer()});
        pipeline.addLast(new ChannelHandler[]{new PacketCodec(databaseProtocolFrontendEngine.getCodecEngine())});
        pipeline.addLast(new ChannelHandler[]{new FrontendChannelLimitationInboundHandler(databaseProtocolFrontendEngine)});
        pipeline.addLast(ProxyFlowControlHandler.class.getSimpleName(), (ChannelHandler)new ProxyFlowControlHandler());
        pipeline.addLast(FrontendChannelInboundHandler.class.getSimpleName(), (ChannelHandler)new FrontendChannelInboundHandler(databaseProtocolFrontendEngine, socketChannel));
        databaseProtocolFrontendEngine.initChannel(socketChannel);
    }

    @Generated
    public ServerHandlerInitializer(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

