/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ratelimit.type;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class QPSJobRateLimitAlgorithm
implements JobRateLimitAlgorithm {
    private static final String QPS_KEY = "qps";
    private int qps = 50;
    private RateLimiter rateLimiter;

    public void init(Properties props) {
        String qpsValue = props.getProperty(QPS_KEY);
        if (!Strings.isNullOrEmpty((String)qpsValue)) {
            this.qps = Integer.parseInt(qpsValue);
            ShardingSpherePreconditions.checkState((this.qps > 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "QPS must be a positive number", new Object[0]));
        }
        this.rateLimiter = RateLimiter.create((double)this.qps);
    }

    @Override
    public void intercept(PipelineSQLOperationType type, Number data) {
        if (type == PipelineSQLOperationType.SELECT) {
            this.rateLimiter.acquire(null == data ? 1 : data.intValue());
        }
    }

    public String getType() {
        return "QPS";
    }
}

