/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.service;

import java.time.LocalDateTime;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.listener.PipelineElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class PipelineJobConfigurationManager {
    private final PipelineJobType jobType;

    public <T extends PipelineJobConfiguration> T getJobConfiguration(String jobId) {
        return this.jobType.getYamlJobConfigurationSwapper().swapToObject(PipelineJobIdUtils.getElasticJobConfigurationPOJO(jobId).getJobParameter());
    }

    public JobConfigurationPOJO convertToJobConfigurationPOJO(PipelineJobConfiguration jobConfig) {
        JobConfigurationPOJO result = new JobConfigurationPOJO();
        result.setJobName(jobConfig.getJobId());
        result.setShardingTotalCount(this.jobType.isForceNoShardingWhenConvertToJobConfigurationPOJO() ? 1 : jobConfig.getJobShardingCount());
        result.setJobParameter(YamlEngine.marshal((Object)this.jobType.getYamlJobConfigurationSwapper().swapToYamlConfiguration(jobConfig)));
        String createTimeFormat = LocalDateTime.now().format(DateTimeFormatterFactory.getStandardFormatter());
        result.getProps().setProperty("create_time", createTimeFormat);
        result.getProps().setProperty("start_time_millis", String.valueOf(System.currentTimeMillis()));
        result.getProps().setProperty("run_count", "1");
        result.setJobListenerTypes(Collections.singletonList(PipelineElasticJobListener.class.getName()));
        result.setJobExecutorServiceHandlerType("SHARDING_TOTAL_COUNT");
        return result;
    }

    @Generated
    public PipelineJobConfigurationManager(PipelineJobType jobType) {
        this.jobType = jobType;
    }
}

