/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLOKPacket
extends MySQLPacket {
    public static final int HEADER = 0;
    private final long affectedRows;
    private final long lastInsertId;
    private final int statusFlag;
    private final int warnings;
    private final String info;

    public MySQLOKPacket(int statusFlag) {
        this(0L, 0L, statusFlag, 0, "");
    }

    public MySQLOKPacket(long affectedRows, long lastInsertId, int statusFlag) {
        this(affectedRows, lastInsertId, statusFlag, 0, "");
    }

    public MySQLOKPacket(MySQLPacketPayload payload) {
        Preconditions.checkArgument((0 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL OK packet must be `0x00`.");
        this.affectedRows = payload.readIntLenenc();
        this.lastInsertId = payload.readIntLenenc();
        this.statusFlag = payload.readInt2();
        this.warnings = payload.readInt2();
        this.info = payload.readStringEOF();
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        payload.writeIntLenenc(this.affectedRows);
        payload.writeIntLenenc(this.lastInsertId);
        payload.writeInt2(this.statusFlag);
        payload.writeInt2(this.warnings);
        payload.writeStringEOF(this.info);
    }

    @Generated
    public MySQLOKPacket(long affectedRows, long lastInsertId, int statusFlag, int warnings, String info) {
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.statusFlag = statusFlag;
        this.warnings = warnings;
        this.info = info;
    }

    @Generated
    public long getAffectedRows() {
        return this.affectedRows;
    }

    @Generated
    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Generated
    public int getStatusFlag() {
        return this.statusFlag;
    }

    @Generated
    public int getWarnings() {
        return this.warnings;
    }

    @Generated
    public String getInfo() {
        return this.info;
    }
}

